package com.xebialabs.deployit.server.jetty;

import com.xebialabs.deployit.cluster.DeployClusterActorSystem;
import org.eclipse.jetty.util.ExceptionUtil;
import org.jboss.resteasy.plugins.spring.SpringContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

import jakarta.servlet.ServletContextEvent;

public class DeploySpringContextLoaderListener extends SpringContextLoaderListener {
    private static final ExceptionUtil.MultiException ex = new ExceptionUtil.MultiException();

    @Override
    public void contextInitialized(ServletContextEvent event) {
        try {
            WebApplicationContext webApplicationContext = (WebApplicationContext) event.getServletContext()
                    .getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);

            DeployClusterActorSystem actorSystem = webApplicationContext
                    .getAutowireCapableBeanFactory().createBean(DeployClusterActorSystem.class);
            actorSystem.boot();

        } catch (RuntimeException | Error re) {
            ex.add(re);
            throw re;
        }
    }
}
