/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import ai.digital.configuration.central.deploy.InitialCentralConfigSetup$;
import ai.digital.deploy.core.common.XldServerPaths$;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.xebialabs.deployit.DeployitBootstrapper;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.XLDeployServer;
import com.xebialabs.deployit.configuration.system.SystemValues$;
import com.xebialabs.deployit.env.ServerActiveProfileRegistry$;
import com.xebialabs.deployit.log.LogbackHelper;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.platform.script.jython.EngineInstance$;
import com.xebialabs.plugin.Xlp$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ApplicationBooter$ {
    public static final ApplicationBooter$ MODULE$ = new ApplicationBooter$();
    private static final Logger logger = LoggerFactory.getLogger(DeployitBootstrapper.class);
    private static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static XLDeployServer xlDeployServer;

    private Logger logger() {
        return logger;
    }

    public String JAVAX_NET_SSL_TRUST_STORE_PASSWORD() {
        return JAVAX_NET_SSL_TRUST_STORE_PASSWORD;
    }

    public XLDeployServer xlDeployServer() {
        return xlDeployServer;
    }

    public void xlDeployServer_$eq(XLDeployServer x$1) {
        xlDeployServer = x$1;
    }

    public void setUpTrustStorePassword() {
        if (Objects.isNull(System.getProperty(this.JAVAX_NET_SSL_TRUST_STORE_PASSWORD())) && Objects.nonNull(ServerConfiguration.getInstance()) && Objects.nonNull(ServerConfiguration.getInstance().getTrustStorePassword())) {
            System.setProperty(this.JAVAX_NET_SSL_TRUST_STORE_PASSWORD(), ServerConfiguration.getInstance().getTrustStorePassword());
            return;
        }
    }

    public void boot(String[] args) {
        this.bootLoggers();
        this.bootPluginClassloader();
        ServerLaunchOptions launchOptions = ServerLaunchOptions.parseCommandLine((String[])args);
        if (launchOptions == null) {
            System.exit(0);
        }
        this.initialiseJython();
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.bootConfigs(launchOptions);
        this.setSecurityProperties();
        PasswordEncrypter.init((SecretKey)DeployitKeys.getPasswordEncryptionKey((String)launchOptions.getRepositoryKeystorePassword()));
        this.bootSystemProperties(launchOptions);
        if (launchOptions.isDoSetup()) {
            System.exit(0);
            return;
        }
    }

    public void bootPluginManagerCli(String[] args) {
        ServerLaunchOptions launchOptions = ServerLaunchOptions.parseCommandLine((String[])args);
        if (launchOptions == null) {
            System.exit(0);
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.bootConfigs(launchOptions);
        PasswordEncrypter.init((SecretKey)DeployitKeys.getPasswordEncryptionKey((String)launchOptions.getRepositoryKeystorePassword()));
        this.bootSystemProperties(launchOptions);
        if (launchOptions.isDoSetup()) {
            System.exit(0);
            return;
        }
    }

    private void bootLoggers() {
        LogbackHelper.disableConsoleLoggerIfNeeded((String)"STDOUT");
        LogbackHelper.enableJavaUtilLoggingBridge();
        this.setUpDefaultLogLevels();
    }

    private void bootPluginClassloader() {
        Files.createDirectories(XldServerPaths$.MODULE$.XL_HOTFIX_PLUGINS_FOLDER().toPath(), new FileAttribute[0]);
        Files.createDirectories(XldServerPaths$.MODULE$.XL_PLUGINS_LOCAL_FOLDER().toPath(), new FileAttribute[0]);
        Files.createDirectories(XldServerPaths$.MODULE$.XL_PLUGINS_OFFICIAL_FOLDER().toPath(), new FileAttribute[0]);
        Xlp$.MODULE$.init(XldServerPaths$.MODULE$.XL_PLUGIN_EXTENSION(), (Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)XldServerPaths$.MODULE$.XL_HOTFIX_PLUGINS_FOLDER(), (List)new .colon.colon((Object)XldServerPaths$.MODULE$.XL_PLUGINS_LOCAL_FOLDER(), (List)new .colon.colon((Object)XldServerPaths$.MODULE$.XL_PLUGINS_OFFICIAL_FOLDER(), (List)Nil$.MODULE$)))).asJava(), Collections.singletonList(XldServerPaths$.MODULE$.EXT_FOLDER()));
    }

    private void bootConfigs(ServerLaunchOptions launchOptions) {
        ServerConfigFile serverConfigFile = new ServerConfigFile(XldServerPaths$.MODULE$.DEFAULT_CONFIGURATION_FILE());
        this.xlDeployServer_$eq(new XLDeployServer(launchOptions, serverConfigFile));
        this.xlDeployServer().prepareConfigs();
        InitialCentralConfigSetup$.MODULE$.setup();
    }

    private void bootSystemProperties(ServerLaunchOptions launchOptions) {
        String profiles = ServerActiveProfileRegistry$.MODULE$.getActiveProfiles(launchOptions, ServerConfiguration.getInstance());
        Object object = this.isExternalConfig(launchOptions, ServerConfiguration.getInstance()) ? SystemValues$.MODULE$.apply(profiles).applyConfigClientOnlySystemValues() : SystemValues$.MODULE$.apply(profiles).applyConfigEmbeddedServerSystemValues(profiles);
        if (ServerConfiguration.getInstance() != null) {
            SystemValues$.MODULE$.apply(ServerConfiguration.getInstance());
            return;
        }
    }

    private boolean isExternalConfig(ServerLaunchOptions launchOptions, ServerConfiguration serverConfiguration) {
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)launchOptions.isExternalConfig()).map((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ApplicationBooter$.$anonfun$isExternalConfig$1(x))).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)serverConfiguration).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.getSpringCloudExternalConfig()))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    private void setUpDefaultLogLevels() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.getLogger("org.eclipse.jetty.server.session").setLevel(Level.WARN);
    }

    private void initialiseJython() {
        try {
            this.logger().info("Starting up Jython engine (might take a while)...");
            EngineInstance$.MODULE$.jython().eval("True");
            this.logger().info("Jython engine loaded [" + EngineInstance$.MODULE$.jython().getFactory().getEngineVersion() + "]");
        }
        catch (Exception e) {
            this.logger().warn("Exception while initialising jython engine", (Throwable)e);
        }
    }

    private void setSecurityProperties() {
        OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(ServerConfiguration.getInstance().getNetworkaddressCacheTTL())).foreach((Function1 & Serializable)ttl -> {
            ApplicationBooter$.$anonfun$setSecurityProperties$1(ttl);
            return BoxedUnit.UNIT;
        });
        this.logger().info("Setting Network Address Cache TTL to " + Security.getProperty("networkaddress.cache.ttl"));
    }

    public static final /* synthetic */ boolean $anonfun$isExternalConfig$1(Object x) {
        return BoxesRunTime.unboxToBoolean((Object)x);
    }

    public static final /* synthetic */ void $anonfun$setSecurityProperties$1(String ttl) {
        Security.setProperty("networkaddress.cache.ttl", ttl);
    }

    private ApplicationBooter$() {
    }
}

