package com.xebialabs.deployit;

import jakarta.servlet.*;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;

import java.io.IOException;

public class MultipartFilter implements Filter {

    private static final MultipartConfigElement MULTI_PART_CONFIG = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data")) {
            request.setAttribute(ServletContextRequest.MULTIPART_CONFIG_ELEMENT, MULTI_PART_CONFIG);
        }
        chain.doFilter(request, response);
    }
}