package com.xebialabs.deployit;

import org.eclipse.jetty.http.HttpStatus;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;

@Component
@Order(1)
public class BeforeLicenseCheckFilter extends OncePerRequestFilter {
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
            throws ServletException, IOException {

        if (response instanceof HttpServletResponse) {
            response = new RedirectResponseWrapper(response);
        }
        filterChain.doFilter(request, response);
    }

    @Override
    protected boolean shouldNotFilter(HttpServletRequest request) {
        String path = request.getRequestURI();
        return ("/" + RedirectResponseWrapper.PRODUCT_REGISTRATION_PAGE).equals(path);
    }

    /**
     * HttpServletResponseWrapper that replaces the 403 error response by redirect to product registration page.
     */
    private class RedirectResponseWrapper extends HttpServletResponseWrapper {
        public static final String PRODUCT_REGISTRATION_PAGE = "productregistration";

        public RedirectResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        @Override
        public void sendError(int sc, String msg) throws IOException {
            if (HttpStatus.PAYMENT_REQUIRED_402 == sc) {
                super.sendRedirect(PRODUCT_REGISTRATION_PAGE);
            } else {
                super.sendError(sc, msg);
            }
        }
    }
}
