package com.xebialabs.deployit.upgrade

import com.typesafe.config.ConfigFactory
import com.xebialabs.deployit.upgrade.CentralConfigVersionFile.CENTRAL_CONFIGURATION_VERSION
import com.xebialabs.deployit.util.PropertyUtil

import java.io._
import java.util.Properties

class CentralConfigVersionFile(centralConfigVersionFile: File,
                               serverConfigFile: File,
                               configFolder: File)
  extends CentralConfigVersion {

  if (!centralConfigVersionFile.exists()) {
    val version = if (serverConfigFile.exists() && has1000ConfFiles)
      "10.0.0"
    else
      "24.3.6"
    updateCentralConfigurationVersion(version)
  }

  def getCentralConfigurationVersion: String = {
    PropertyUtil.readPropertiesFile(centralConfigVersionFile).getProperty(CENTRAL_CONFIGURATION_VERSION)
  }

  def updateCentralConfigurationVersion(version: String): Unit = {
    val properties = new Properties
    properties.put(CENTRAL_CONFIGURATION_VERSION, version)
    PropertyUtil.storePropertiesFile(centralConfigVersionFile, properties)
  }

  def has1000ConfFiles: Boolean = {
    val commandWhitelistFile = new File(configFolder, "command-whitelist.json")
    val dbAnonymizeFile = new File(configFolder, "db-anonymize.json")
    val xlDeployConf = new File(configFolder, "xl-deploy.conf")
    val deployitDefaultsFile = new File(configFolder, "deployit-defaults.properties")

    val hasOldConfigInXlDeployConf = if (xlDeployConf.exists()) {
      val config = ConfigFactory.parseFile(xlDeployConf)
      Seq("xl.deploy.websockets", "xl.secret-complexity", "xl.jmx")
        .exists(config.hasPath)
    } else {
      false
    }

    hasOldConfigInXlDeployConf || commandWhitelistFile.exists() || dbAnonymizeFile.exists() || deployitDefaultsFile.exists()
  }
}

object CentralConfigVersionFile {
  val CENTRAL_CONFIGURATION_VERSION = "central.configuration.version"
}
