package com.xebialabs.deployit.server.jetty;

import com.xebialabs.deployit.ServerConfiguration;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.URLResourceFactory;

import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;

public class XLDWebResource extends Resource {
    @Override
    public Path getPath() {
        return null;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isReadable() {
        return false;
    }

    @Override
    public URI getURI() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getFileName() {
        return null;
    }

    @Override
    public Resource resolve(String subUriPath) {
        if (!subUriPath.startsWith("/")) {
            subUriPath = "/" + subUriPath;
        }
        subUriPath = subUriPath.replace("-@project.version@", "");
        final String resourcePath = ServerConfiguration.DEFAULT_WEBCONTENT_PACKAGE + subUriPath;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
        try {
            Resource r = null;
            ResourceFactory resourceFactory = new URLResourceFactory();
            if (url != null) {
                if (Objects.equals(url.getProtocol(), "xlp")) {
                    r = ResourceFactory.root().newMemoryResource(url);
                } else {
                    r = resourceFactory.newResource(url);
                }
            }
            return r;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exists() {
        return true;
    }
}
