/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import ai.digital.configuration.central.deploy.InitialCentralConfigSetup$;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.xebialabs.deployit.DeployitBootstrapper;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.XLDeployServer;
import com.xebialabs.deployit.XldServerPaths;
import com.xebialabs.deployit.configuration.system.SystemValues$;
import com.xebialabs.deployit.env.ServerActiveProfiles$;
import com.xebialabs.deployit.log.LogbackHelper;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.platform.script.jython.EngineInstance$;
import com.xebialabs.plugin.Xlp$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class ApplicationBooter$ {
    public static final ApplicationBooter$ MODULE$ = new ApplicationBooter$();
    private static final Logger logger = LoggerFactory.getLogger(DeployitBootstrapper.class);
    private static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static XLDeployServer xlDeployServer;

    private Logger logger() {
        return logger;
    }

    public String JAVAX_NET_SSL_TRUST_STORE_PASSWORD() {
        return JAVAX_NET_SSL_TRUST_STORE_PASSWORD;
    }

    public XLDeployServer xlDeployServer() {
        return xlDeployServer;
    }

    public void xlDeployServer_$eq(XLDeployServer x$1) {
        xlDeployServer = x$1;
    }

    public void setUpTrustStorePassword() {
        block0: {
            if (!Objects.isNull(System.getProperty(this.JAVAX_NET_SSL_TRUST_STORE_PASSWORD())) || !Objects.nonNull(ServerConfiguration.getInstance()) || !Objects.nonNull(ServerConfiguration.getInstance().getTrustStorePassword())) break block0;
            System.setProperty(this.JAVAX_NET_SSL_TRUST_STORE_PASSWORD(), ServerConfiguration.getInstance().getTrustStorePassword());
        }
    }

    public void boot(String[] args) {
        block1: {
            this.bootLoggers();
            this.bootPluginClassloader();
            ServerLaunchOptions launchOptions = ServerLaunchOptions.parseCommandLine((String[])args);
            if (launchOptions == null) {
                System.exit(0);
            }
            this.initialiseJython();
            Security.addProvider((Provider)new BouncyCastleProvider());
            this.bootConfigs(launchOptions);
            PasswordEncrypter.init((SecretKey)DeployitKeys.getPasswordEncryptionKey((String)launchOptions.getRepositoryKeystorePassword()));
            this.bootSystemProperties(launchOptions);
            if (!launchOptions.isDoSetup()) break block1;
            System.exit(0);
        }
    }

    public void bootPluginManagerCli(String[] args) {
        block1: {
            this.bootLoggers();
            ServerLaunchOptions launchOptions = ServerLaunchOptions.parseCommandLine((String[])args);
            if (launchOptions == null) {
                System.exit(0);
            }
            Security.addProvider((Provider)new BouncyCastleProvider());
            this.bootConfigs(launchOptions);
            PasswordEncrypter.init((SecretKey)DeployitKeys.getPasswordEncryptionKey((String)launchOptions.getRepositoryKeystorePassword()));
            this.bootSystemProperties(launchOptions);
            if (!launchOptions.isDoSetup()) break block1;
            System.exit(0);
        }
    }

    private void bootLoggers() {
        LogbackHelper.disableConsoleLoggerIfNeeded((String)"STDOUT");
        LogbackHelper.enableJavaUtilLoggingBridge();
        this.setUpDefaultLogLevels();
    }

    private void bootPluginClassloader() {
        Files.createDirectories(XldServerPaths.XL_HOTFIX_PLUGINS_FOLDER.toPath(), new FileAttribute[0]);
        Files.createDirectories(XldServerPaths.XL_PLUGINS_LOCAL_FOLDER.toPath(), new FileAttribute[0]);
        Files.createDirectories(XldServerPaths.XL_PLUGINS_OFFICIAL_FOLDER.toPath(), new FileAttribute[0]);
        Xlp$.MODULE$.init("xldp", (Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{XldServerPaths.XL_HOTFIX_PLUGINS_FOLDER, XldServerPaths.XL_PLUGINS_LOCAL_FOLDER, XldServerPaths.XL_PLUGINS_OFFICIAL_FOLDER}))).asJava(), Collections.singletonList(XldServerPaths.EXT_FOLDER));
    }

    private void bootConfigs(ServerLaunchOptions launchOptions) {
        ServerConfigFile serverConfigFile = new ServerConfigFile(XldServerPaths.DEFAULT_CONFIGURATION_FILE);
        this.xlDeployServer_$eq(new XLDeployServer(launchOptions, serverConfigFile));
        this.xlDeployServer().prepareConfigs();
        InitialCentralConfigSetup$.MODULE$.setup();
    }

    private void bootSystemProperties(ServerLaunchOptions launchOptions) {
        block0: {
            Object object = this.isExternalConfig(launchOptions, ServerConfiguration.getInstance()) ? SystemValues$.MODULE$.apply(ServerActiveProfiles$.MODULE$.allWithoutConfigServer()).applyConfigClientOnlySystemValues() : SystemValues$.MODULE$.apply(ServerActiveProfiles$.MODULE$.allWithConfigServer()).applyConfigEmbeddedServerSystemValues(ServerActiveProfiles$.MODULE$.allWithConfigServer());
            if (ServerConfiguration.getInstance() == null) break block0;
            SystemValues$.MODULE$.apply(ServerConfiguration.getInstance());
        }
    }

    private boolean isExternalConfig(ServerLaunchOptions launchOptions, ServerConfiguration serverConfiguration) {
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)launchOptions.isExternalConfig()).map((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ApplicationBooter$.$anonfun$isExternalConfig$1(x))).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)serverConfiguration).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.getSpringCloudExternalConfig()))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    private void setUpDefaultLogLevels() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        lc.getLogger("org.eclipse.jetty.server.session").setLevel(Level.WARN);
    }

    private void initialiseJython() {
        try {
            this.logger().info("Starting up Jython engine (might take a while)...");
            EngineInstance$.MODULE$.jython().eval("True");
            this.logger().info(new StringBuilder(23).append("Jython engine loaded [").append(EngineInstance$.MODULE$.jython().getFactory().getEngineVersion()).append("]").toString());
        }
        catch (Exception e) {
            this.logger().warn("Exception while initialising jython engine", (Throwable)e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$isExternalConfig$1(Object x) {
        return BoxesRunTime.unboxToBoolean((Object)x);
    }

    private ApplicationBooter$() {
    }
}

