/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.setup.Setup;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlplatform.config.ConfigLoader;
import com.xebialabs.xlplatform.jmx.JMXAgent;
import com.xebialabs.xlplatform.jmx.JMXSettings;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.crypto.SecretKey;
import kamon.Kamon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLDeployServer {
    private static final Logger logger = LoggerFactory.getLogger(XLDeployServer.class);
    private static final String XL_JMX_KEY = "xl.jmx";
    private static final String KAMON_KEY = "kamon";
    private static final List<File> DEPRECATED_SYSTEM_CONFIG_FILES = Arrays.asList(new File("conf", "system.conf"), new File("conf", "maven.conf"), new File("conf", "extensions.conf"), new File("conf", "planner.conf"), new File("conf", "scheduler.conf"));
    private final ServerLaunchOptions launchOptions;
    private final ServerConfigFile serverConfigFile;
    private boolean isConfigAndPasswordInitDone = false;

    public XLDeployServer(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile) {
        this.launchOptions = launchOptions;
        this.serverConfigFile = serverConfigFile;
    }

    void prepareConfigs() {
        this.checkDeprecatedSystemConf();
        if (this.launchOptions.isDoSetup()) {
            XLDeployServer.startSetup(this.launchOptions, this.serverConfigFile);
        } else {
            if (!this.serverConfigFile.exists()) {
                logger.warn("Configuration not found...");
                XLDeployServer.startSetup(this.launchOptions, this.serverConfigFile);
            } else if (this.launchOptions.isReinitialize()) {
                logger.warn("Not re-initializing as the -setup flag is missing.");
            }
            if (!this.isConfigAndPasswordInitDone) {
                this.loadConfigAndInitPasswordEncryptionKey();
            }
            Config config = ConfigLoader.loadWithDynamic((String)"xl-deploy.conf");
            this.initializeJMXAgent(config);
        }
    }

    private void checkDeprecatedSystemConf() {
        DEPRECATED_SYSTEM_CONFIG_FILES.forEach(configFile -> {
            if (configFile.exists()) {
                throw new RuntimeException("You are not allowed to have a " + configFile.getName() + " file on the 'conf' folder. Please merge it into 'conf/xl-deploy.conf', remove the file and restart the server.");
            }
        });
    }

    private void initializeJMXAgent(Config config) {
        JMXSettings jmxSettings = new JMXSettings(config);
        new JMXAgent().start(jmxSettings);
        if (jmxSettings.enabled()) {
            Config xlJmxConfig = config.getConfig(XL_JMX_KEY);
            Config defaultKamonConfig = config.withOnlyPath(KAMON_KEY);
            Config kamonConfig = xlJmxConfig.hasPath(KAMON_KEY) ? xlJmxConfig.withOnlyPath(KAMON_KEY).withFallback((ConfigMergeable)defaultKamonConfig) : defaultKamonConfig;
            Kamon.init((Config)kamonConfig);
        }
    }

    private static void startSetup(ServerLaunchOptions launchOptions, ServerConfigFile serverConfigFile) {
        new Setup("XL Deploy Server", serverConfigFile, launchOptions).run();
    }

    void loadConfigAndInitPasswordEncryptionKey() {
        ServerConfiguration config = this.serverConfigFile.loadConfig(false, false);
        String repositoryKeyStorePassword = this.launchOptions.getRepositoryKeystorePassword() != null ? this.launchOptions.getRepositoryKeystorePassword() : config.getRepositoryKeyStorePassword();
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            throw new RuntimeException("Could not load the encryption key. The server will not start.");
        }
        config.loadEncryptedPasswords();
        this.serverConfigFile.saveDirtyConfiguration(config);
        ServerConfiguration.setInstance((ServerConfiguration)config);
        ServerLaunchOptions.setInstance((ServerLaunchOptions)this.launchOptions);
        this.isConfigAndPasswordInitDone = true;
    }
}

