/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import akka.actor.ActorSystem;
import akka.actor.Address;
import com.google.common.base.Charsets;
import com.tqdev.metrics.core.MetricRegistry;
import com.tqdev.metrics.http.MeasureRequestPathFilter;
import com.tqdev.metrics.jetty.InstrumentedHandler;
import com.typesafe.config.Config;
import com.xebialabs.deployit.AcceptHeaderConditionalFilter;
import com.xebialabs.deployit.CustomErrorHandler;
import com.xebialabs.deployit.FlexLicenseValidationFilter;
import com.xebialabs.deployit.HttpErrorHandler;
import com.xebialabs.deployit.LicenseExpiryCheckFilter;
import com.xebialabs.deployit.NoCacheFilter;
import com.xebialabs.deployit.RootPageForwardFilter;
import com.xebialabs.deployit.RootPageMissingErrorHandler;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.ServerState;
import com.xebialabs.deployit.XLRequestLogImpl;
import com.xebialabs.deployit.XLWebApplicationContext;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.core.config.InProcessConfig;
import com.xebialabs.deployit.engine.spi.event.SystemStartedEvent;
import com.xebialabs.deployit.engine.spi.event.SystemStoppedEvent;
import com.xebialabs.deployit.engine.tasker.EnqueueTaskListener;
import com.xebialabs.deployit.errors.LicenseMissingErrorHandler;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.hotstandby.HotStandbyActorSystem;
import com.xebialabs.deployit.jetty.ClassPathResourceContentServlet;
import com.xebialabs.deployit.jetty.DeployitSpringContextLoaderListener;
import com.xebialabs.deployit.jetty.MaintenanceModeFilter;
import com.xebialabs.deployit.jetty.NoOptionsFilter;
import com.xebialabs.deployit.jetty.RequestHeadersEncodedAsParametersFilter;
import com.xebialabs.deployit.tasksystem.TaskActorSystem;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.deployit.util.SslFactoryBuilder;
import com.xebialabs.license.LicenseRegistrationServlet;
import com.xebialabs.xldeploy.jms.broker.EmbeddedBroker;
import com.xebialabs.xlplatform.config.ConfigLoader;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServletInitializer;
import com.xebialabs.xlplatform.endpoints.servlet.FlexAkkaStreamServlet;
import java.net.ServerSocket;
import java.security.Provider;
import java.security.Security;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.SessionTrackingMode;
import nl.javadude.t2bus.Subscribe;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.filter.ShallowEtagHeaderFilter;
import org.springframework.web.servlet.DispatcherServlet;

public class Server {
    private static final String SPRING_CTX_CFG_LOCATION_KEY = "contextConfigLocation";
    private static final String SPRING_CONFIG = "classpath:spring/deployit-context.xml,classpath:deployit-security.xml,classpath*:hotfix-context.xml";
    private static final String CONTEXT_PATH = "deployit";
    private final ServerConfiguration serverConfiguration;
    private final String name;
    private final String springConfig;
    private final String contextPath;
    private final ServerState serverState = ServerState.getInstance();
    private org.eclipse.jetty.server.Server jettyServer;
    private WebAppContext contextRoot;
    private static final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private EmbeddedBroker embeddedBroker;
    private static final Logger logger = LoggerFactory.getLogger(Server.class);

    static void start(String name, ServerLaunchOptions launchOptions, ServerConfigFile configFile, ServerConfiguration config) {
        String repositoryKeyStorePassword = launchOptions.getRepositoryKeystorePassword() != null ? launchOptions.getRepositoryKeystorePassword() : config.getRepositoryKeyStorePassword();
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            System.out.println("Could not load the encryption key. " + name + " will not start.");
            return;
        }
        config.loadEncryptedPasswords();
        configFile.saveDirtyConfiguration(config);
        Server server = new Server(name, config);
        server.start();
    }

    private Server(String name, ServerConfiguration configuration) {
        this.serverConfiguration = configuration;
        this.name = name;
        this.springConfig = SPRING_CONFIG;
        this.contextPath = CONTEXT_PATH;
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (this.portIsAvailable()) {
            this.setupJetty();
            Server.bootPlugins();
            this.setupApiFilters();
            this.startInternalBroker();
            this.setupAccessLog();
            this.setupAfterAuthFilters();
            this.setupRest();
        } else {
            logger.error("Cannot start {}; port {} already in use.", (Object)name, (Object)this.serverConfiguration.getHttpPort());
            logger.error("Perhaps another instance of {} is running.", (Object)name);
            System.exit(1);
        }
    }

    private boolean portIsAvailable() {
        try {
            ServerSocket socket = new ServerSocket(this.serverConfiguration.getHttpPort());
            socket.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void setupJetty() {
        ServerConnector connector;
        int port = this.serverConfiguration.getHttpPort();
        String webContextRoot = this.serverConfiguration.getWebContextRoot();
        String documentRootPackage = "web";
        if (logger.isDebugEnabled()) {
            logger.debug("Setting up Jetty server on port {} with context root {} using package {} for document root.", new Object[]{port, webContextRoot, documentRootPackage});
        }
        this.jettyServer = new org.eclipse.jetty.server.Server((ThreadPool)this.buildThreadPool());
        if (this.serverConfiguration.isSsl()) {
            logger.debug("Setting up Jetty to use SSL");
            SslContextFactory.Server sslContextFactory = SslFactoryBuilder.build(this.serverConfiguration);
            HttpConnectionFactory httpConnectionFactory = this.getHttpConnectionFactory();
            connector = new ServerConnector(this.jettyServer, (SslContextFactory)sslContextFactory, new ConnectionFactory[]{httpConnectionFactory});
        } else {
            HttpConnectionFactory httpConnectionFactory = this.getHttpConnectionFactory();
            connector = new ServerConnector(this.jettyServer, new ConnectionFactory[]{httpConnectionFactory});
        }
        connector.setIdleTimeout((long)this.serverConfiguration.getHttpIdleTimeoutMillis().intValue());
        connector.setHost(this.serverConfiguration.getHttpBindAddress());
        connector.setPort(port);
        logger.info("Connector listen {} on {}:{}", new Object[]{this.serverConfiguration.isSsl() ? "secure" : "no-secure", connector.getHost(), connector.getPort()});
        this.jettyServer.addConnector((Connector)connector);
        this.jettyServer.setStopTimeout(1000L);
        CustomErrorHandler customErrorHandler = new CustomErrorHandler(new HttpErrorHandler[]{new RootPageMissingErrorHandler(this.serverConfiguration.getWebWelcomePage()), new LicenseMissingErrorHandler()});
        customErrorHandler.setShowStacks(false);
        this.contextRoot = new WebAppContext((HandlerContainer)this.jettyServer, webContextRoot, !this.serverConfiguration.isActiveUserSessions() ? this.newSessionHandler() : null, (SecurityHandler)new ConstraintSecurityHandler(), new ServletHandler(), (ErrorHandler)customErrorHandler, 0);
        this.contextRoot.insertHandler((HandlerWrapper)new InstrumentedHandler(MetricRegistry.getInstance()));
        this.contextRoot.addFilter(MeasureRequestPathFilter.class, "*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("contentTypes", "application/json|text/html|text/xml|application/xml");
        this.contextRoot.addFilter(FlexLicenseValidationFilter.class, "/deployit/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("whiteListedPaths", "");
        this.contextRoot.addFilter(NoOptionsFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
        if (this.serverConfiguration.getWebWelcomePage() != null) {
            this.contextRoot.addFilter(RootPageForwardFilter.class, "/", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("ForwardTarget", this.serverConfiguration.getWebWelcomePage());
        }
        this.contextRoot.addFilter(RequestHeadersEncodedAsParametersFilter.class, "/deployit/reports/*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(RequestHeadersEncodedAsParametersFilter.class, "/deployit/repository/*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.setClassLoader(Thread.currentThread().getContextClassLoader());
        ServletHolder extensionApiServletHolder = new ServletHolder(FlexAkkaStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        Config config = ConfigLoader.loadWithDynamic((String)"xl-deploy.conf");
        this.contextRoot.addEventListener((EventListener)new AkkaStreamServletInitializer(config));
        this.contextRoot.addServlet(extensionApiServletHolder, "/api/*");
        this.contextRoot.addFilter(new FilterHolder((Filter)new AcceptHeaderConditionalFilter((Filter)new ShallowEtagHeaderFilter(), "application/json")), "/deployit/metadata/*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(NoCacheFilter.class, "/", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(CharacterEncodingFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameters((Map)new HashMap<String, String>(){
            {
                this.put("encoding", Charsets.UTF_8.name());
                this.put("forceEncoding", "true");
            }
        });
        ServletHolder registrationServletHolder = new ServletHolder(LicenseRegistrationServlet.class);
        registrationServletHolder.setInitParameter("productName", "XL Deploy");
        registrationServletHolder.setInitParameter("productLogoUrl", "images/xl_deploy_logo_green.svg");
        registrationServletHolder.setInitParameter("activationUrl", "https://xebialabs.com/products/xl-deploy/trial/activation");
        this.contextRoot.addServlet(registrationServletHolder, "/productregistration/*");
        ServletHolder defaultServletHolder = new ServletHolder();
        defaultServletHolder.setServlet((Servlet)new ClassPathResourceContentServlet(documentRootPackage));
        defaultServletHolder.setInitParameter("dirAllowed", "false");
        this.contextRoot.addServlet(defaultServletHolder, "/");
    }

    private HttpConnectionFactory getHttpConnectionFactory() {
        HttpConfiguration configuration = new HttpConfiguration();
        configuration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(true, TimeUnit.SECONDS.convert(365L, TimeUnit.DAYS), true));
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(configuration, HttpCompliance.RFC2616);
        httpConnectionFactory.getHttpConfiguration().setSendServerVersion(false);
        return httpConnectionFactory;
    }

    private void setupAccessLog() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        XLRequestLogImpl requestLogger = new XLRequestLogImpl("conf/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLogger);
        this.contextRoot.insertHandler((HandlerWrapper)requestLogHandler);
    }

    private SessionHandler newSessionHandler() {
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
        sessionHandler.setSessionCookie("SESSION_XLD");
        sessionHandler.setHttpOnly(true);
        if (!this.serverConfiguration.isSsl()) {
            sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration.isSecureCookieEnabled());
        }
        return sessionHandler;
    }

    private QueuedThreadPool buildThreadPool() {
        return new QueuedThreadPool(this.serverConfiguration.getMaxThreads(), this.serverConfiguration.getMinThreads());
    }

    private static void bootPlugins() {
        LocalBooter.boot();
    }

    private void setupAfterAuthFilters() {
        FilterHolder maintenanceFilterHolder = this.contextRoot.addFilter(MaintenanceModeFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
        maintenanceFilterHolder.setInitParameter("maintenance.forbidden_paths", this.serverConfiguration.getMaintenanceForbiddenRequests());
        maintenanceFilterHolder.setInitParameter("maintenance.context_root", this.serverConfiguration.getWebContextRoot());
        this.contextRoot.addFilter(LicenseExpiryCheckFilter.class, "/deployit/*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(LicenseExpiryCheckFilter.class, "/xldeploy/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupApiFilters() {
        Map params = this.contextRoot.getInitParams();
        params.put(SPRING_CTX_CFG_LOCATION_KEY, this.springConfig);
        params.put("contextClass", XLWebApplicationContext.class.getName());
        if (logger.isDebugEnabled()) {
            logger.debug("Using Spring configuration - " + (String)params.get(SPRING_CTX_CFG_LOCATION_KEY));
        }
        if (this.serverConfiguration.isActiveUserSessions()) {
            FilterHolder sessionFilter = new FilterHolder(DelegatingFilterProxy.class);
            sessionFilter.setName("springSessionRepositoryFilter");
            this.contextRoot.addFilter(sessionFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
            this.contextRoot.addFilter(sessionFilter, "/*", EnumSet.of(DispatcherType.ERROR));
        }
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        this.contextRoot.addFilter(filter, "/", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(filter, "/login", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(filter, "/login/*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(filter, "/logout", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(filter, "/oauth2/authorization/xl-deploy", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(filter, "/" + this.contextPath + "/*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(filter, "/api/*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(filter, "/xldeploy/*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupRest() {
        this.contextRoot.addEventListener((EventListener)new ResteasyBootstrap());
        this.contextRoot.addEventListener((EventListener)new DeployitSpringContextLoaderListener());
        ServletHolder servletHolder = new ServletHolder(DispatcherServlet.class);
        servletHolder.setDisplayName("defaultservlet");
        servletHolder.getInitParameters().put(SPRING_CTX_CFG_LOCATION_KEY, "classpath:spring/deployit-spring-web.xml");
        servletHolder.setInitOrder(1);
        ServletHolder servletCsrfHolder = new ServletHolder(DispatcherServlet.class);
        servletCsrfHolder.setDisplayName("csrfservlet");
        servletCsrfHolder.getInitParameters().put(SPRING_CTX_CFG_LOCATION_KEY, "classpath:spring/csrf-deployit-spring-web.xml");
        servletCsrfHolder.setInitOrder(1);
        this.contextRoot.getInitParams().put("resteasy.servlet.mapping.prefix", "/" + this.contextPath);
        this.contextRoot.getInitParams().put("resteasy.document.expand.entity.references", "false");
        this.contextRoot.addServlet(servletHolder, "/" + this.contextPath + "/*");
        this.contextRoot.setResourceBase(".");
        this.contextRoot.addServlet(servletCsrfHolder, "/xldeploy/*");
    }

    private void setupHotStandby(WebApplicationContext wac) {
        HotStandbyActorSystem actorSystem = (HotStandbyActorSystem)wac.getAutowireCapableBeanFactory().createBean(HotStandbyActorSystem.class);
        actorSystem.boot();
    }

    private void setupSessionTimeout() {
        int sessionTimeoutSeconds = (int)TimeUnit.MINUTES.toSeconds(this.serverConfiguration.getClientSessionTimeoutMinutes());
        this.contextRoot.getSessionHandler().setMaxInactiveInterval(sessionTimeoutSeconds);
    }

    private void start() {
        try {
            EventBusHolder.register((Object)this.serverState);
            EventBusHolder.register((Object)this);
            if (logger.isDebugEnabled()) {
                logger.debug("Starting Jetty");
            }
            this.jettyServer.start();
            if (!this.serverConfiguration.isActiveUserSessions()) {
                this.setupSessionTimeout();
            }
            DeployitSpringContextLoaderListener.checkCorrectlyInitialized();
            this.setupHotStandby(DeployitSpringContextLoaderListener.getWebApplicationContext());
            if (logger.isDebugEnabled()) {
                logger.debug("Jetty started");
            }
            this.createShutdownEventThreadAndShutdownHook();
            EventBusHolder.publish((Object)new SystemStartedEvent());
        }
        catch (Exception e) {
            logger.error("Error occurred while starting Jetty", (Throwable)e);
            this.stop();
        }
    }

    private synchronized void stop() {
        if (this.jettyServer.isRunning()) {
            logger.info("Shutting down {}.", (Object)this.name);
            try {
                this.jettyServer.stop();
                logger.info("{} has shut down.", (Object)this.name);
            }
            catch (Exception e) {
                logger.error("Error occurred while trying to stop Jetty", (Throwable)e);
            }
        }
    }

    private void createShutdownEventThreadAndShutdownHook() {
        Thread shutdownEventThread = new Thread(() -> {
            try {
                shutdownLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            logger.error("Shutting down {} because a shutdown event was received.", (Object)this.name);
            this.stop();
        });
        shutdownEventThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            logger.error("Shutting down {} from the JVM shutdown hook because the process is being terminated.", (Object)this.name);
            this.stop();
        }));
    }

    public WebAppContext getContextRoot() {
        return this.contextRoot;
    }

    @Subscribe
    public void startListener(SystemStartedEvent event) {
        logger.info("{} has started.", (Object)this.name);
        this.printRemotingAddress();
        logger.info("You can now point your browser to {}", (Object)this.serverConfiguration.getServerUrl());
    }

    private void printRemotingAddress() {
        Address defaultAddress;
        ActorSystem actorSystem = TaskActorSystem.actorSystem();
        if (!actorSystem.settings().config().getBoolean("xl.task.in-process-worker") && (defaultAddress = actorSystem.provider().getDefaultAddress()).host().isDefined()) {
            logger.info("External workers can connect to {}:{}", defaultAddress.host().get(), defaultAddress.port().get());
        }
    }

    private void startInternalBroker() {
        ActorSystem actorSystem = TaskActorSystem.actorSystem();
        Config cfg = actorSystem.settings().config();
        if (cfg.getBoolean("xl.task.in-process-worker")) {
            Config cfgRegion = cfg.getConfig("xl.task.queue.in-process");
            InProcessConfig inProcessConfig = new InProcessConfig(cfgRegion);
            this.embeddedBroker = new EmbeddedBroker(inProcessConfig);
            this.embeddedBroker.start();
        }
    }

    @Subscribe
    public void shutdownEmbeddedBrokerHandler(SystemStoppedEvent event) {
        if (this.embeddedBroker != null) {
            EnqueueTaskListener.shutdownListeners();
            this.embeddedBroker.shutdown();
        }
    }

    @Subscribe
    public void shutdownListener(ShutdownEvent event) {
        logger.trace("Received shutdown event.");
        shutdownLatch.countDown();
        System.exit(0);
    }
}

