package com.xebialabs.deployit.server.api.orchestrator;

import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * An Orchestrator converts a DeltaSpecification into a (unresolved) Plan, which can then be resolved to result in steps.
 * Using the {@link com.xebialabs.deployit.plugin.api.deployment.execution.Plans} utilities, it is easy to assimilate the plan.
 */
public interface Orchestrator {

	@Retention(RetentionPolicy.RUNTIME)
	@Target(ElementType.TYPE)
	public @interface Metadata {
		public String name();
		public String description() default "";
	}
	
	Plan orchestrate(DeltaSpecification specification);
}
