/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.api.upgrade;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    public static final String VERSION_0 = "0.0.0";
    private String component;
    private int major;
    private int minor;
    private int micro;
    private String classifier = "";

    public static Version valueOf(String string, String string2) {
        Matcher matcher = Pattern.compile("([0-9]+)\\.([0-9]+)\\.?([0-9]+)?-?(.*)$").matcher(string2);
        if (!matcher.matches()) {
            throw new RuntimeException("Unsupported version number format " + string2);
        }
        Version version = new Version();
        version.component = string;
        version.major = Integer.parseInt(matcher.group(1));
        version.minor = Integer.parseInt(matcher.group(2));
        if (matcher.group(3) != null) {
            version.micro = Integer.parseInt(matcher.group(3));
        }
        if (matcher.group(4) != null) {
            version.classifier = matcher.group(4);
        }
        return version;
    }

    public String getComponent() {
        return this.component;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getVersion() {
        if (this.classifier.isEmpty()) {
            return String.format("%d.%d.%d", this.major, this.minor, this.micro);
        }
        return String.format("%d.%d.%d-%s", this.major, this.minor, this.micro, this.classifier);
    }

    public String toString() {
        return String.format("%s %s", this.component, this.getVersion());
    }

    @Override
    public int compareTo(Version version) {
        if (!this.component.equals(version.component)) {
            throw new IllegalArgumentException("Cannot compare versions for 2 components: " + this.toString() + " and " + version.toString());
        }
        if (this.major != version.major) {
            return this.major - version.major;
        }
        if (this.minor != version.minor) {
            return this.minor - version.minor;
        }
        if (this.micro != version.micro) {
            return this.micro - version.micro;
        }
        return this.classifier.compareTo(version.classifier);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Version version = (Version)object;
        return this.major == version.major && this.micro == version.micro && this.minor == version.minor && this.classifier.equals(version.classifier) && this.component.equals(version.component);
    }

    public int hashCode() {
        int n = this.component.hashCode();
        n = 31 * n + this.major;
        n = 31 * n + this.minor;
        n = 31 * n + this.micro;
        n = 31 * n + this.classifier.hashCode();
        return n;
    }
}

