/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.api.importer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import java.util.List;
import java.util.Set;

public final class ImportedPackage {
    private Application application;
    private Version version;
    private final PackageInfo packageInfo;

    public ImportedPackage(PackageInfo packageInfo) {
        this.packageInfo = packageInfo;
        this.createApplicationEntity(packageInfo);
        this.createDeploymentPackageEntity(packageInfo);
    }

    public ImportedPackage(PackageInfo packageInfo, Application application, Version version) {
        this.packageInfo = packageInfo;
        this.application = application;
        this.version = version;
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    public Application getApplication() {
        return this.application;
    }

    public Version getVersion() {
        return this.version;
    }

    @Deprecated
    public DeploymentPackage getDeploymentPackage() {
        return (DeploymentPackage)this.version;
    }

    public List<Deployable> getDeployables() {
        return Lists.newArrayList((Iterable)this.version.getDeployables());
    }

    public void setDeployables(List<Deployable> list) {
        Preconditions.checkState((boolean)(this.version instanceof DeploymentPackage), (String)"Cannot set deployables on a non udm.DeploymentPackage (%s)", (Object[])new Object[]{this.version.getType()});
        ((DeploymentPackage)this.version).setDeployables((Set)Sets.newHashSet(list));
    }

    public void addDeployable(Deployable deployable) {
        Preconditions.checkState((boolean)(this.version instanceof DeploymentPackage), (String)"Cannot add deployables on a non udm.DeploymentPackage (%s)", (Object[])new Object[]{this.version.getType()});
        ((DeploymentPackage)this.version).addDeployable(deployable);
    }

    private void createApplicationEntity(PackageInfo packageInfo) {
        this.application = (Application)Type.valueOf(Application.class).getDescriptor().newInstance();
        this.application.setId(packageInfo.getApplicationId());
    }

    private void createDeploymentPackageEntity(PackageInfo packageInfo) {
        this.version = (Version)Type.valueOf(DeploymentPackage.class).getDescriptor().newInstance();
        this.version.setId(IdGenerator.generateId((ConfigurationItem)this.application, packageInfo.applicationVersion));
        this.version.setApplication(this.application);
    }
}

