/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.api.orchestrator;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionsHolder;
import com.xebialabs.deployit.server.api.orchestrator.Orchestrator;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrchestratorRegistry {
    private static final Logger logger = LoggerFactory.getLogger(OrchestratorRegistry.class);
    private static Map<String, Orchestrator> lookup = Maps.newHashMap();

    private static void register(Class<? extends Orchestrator> clazz) throws IllegalAccessException, InstantiationException {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return;
        }
        String string = clazz.getSimpleName();
        if (clazz.isAnnotationPresent(Orchestrator.Metadata.class)) {
            Orchestrator.Metadata metadata = clazz.getAnnotation(Orchestrator.Metadata.class);
            string = metadata.name();
        }
        logger.info("Registering Orchestrator [{}] under name [{}]", clazz, (Object)string);
        lookup.put(string, clazz.newInstance());
    }

    public static Orchestrator getOrchestrator(String string) {
        return lookup.get(string);
    }

    public static Set<String> all() {
        return Sets.newHashSet(lookup.keySet());
    }

    static {
        Set set = ReflectionsHolder.getSubTypesOf(Orchestrator.class);
        for (Class clazz : set) {
            try {
                OrchestratorRegistry.register(clazz);
            }
            catch (Exception exception) {
                throw new RuntimeException("Couldn't boot the OrchestratorRegistry", exception);
            }
        }
    }
}

