package com.xebialabs.deployit.server.api.upgrade;

public abstract class Upgrade implements Comparable<Upgrade> {

    public abstract boolean doUpgrade() throws UpgradeException;

    public abstract Version upgradeVersion();

    @Override
    public final int compareTo(Upgrade o) {
        if (upgradeVersion().compareTo(o.upgradeVersion()) == 0) {
            return this.getClass().getSimpleName().compareTo(o.getClass().getSimpleName());
        } else {
            return upgradeVersion().compareTo(o.upgradeVersion());
        }
    }

    public final boolean shouldBeApplied(Version currentVersion) {
        return currentVersion.getComponent().equals(upgradeVersion().getComponent()) && currentVersion.compareTo(upgradeVersion()) < 0;
    }
}

