package com.xebialabs.deployit.server.api.importer;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;

import java.util.List;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.APPLICATIONS;
import static com.xebialabs.deployit.server.api.util.IdGenerator.generateId;

public final class ImportedPackage {

	private Application application;

	private DeploymentPackage deploymentPackage;

	private List<Deployable> deployables = Lists.newArrayList();
	private final PackageInfo packageInfo;

	public ImportedPackage(PackageInfo packageInfo) {
		this.packageInfo = packageInfo;
		createApplicationEntity(packageInfo);
		createDeploymentPackageEntity(packageInfo);
	}

	public ImportedPackage(PackageInfo packageInfo, Application applicationEntity, DeploymentPackage deploymentPackageEntity) {
		this.packageInfo = packageInfo;
		this.application = applicationEntity;
		this.deploymentPackage = deploymentPackageEntity;
	}

	public PackageInfo getPackageInfo() {
		return packageInfo;
	}

	public Application getApplication() {
		return application;
	}

	public DeploymentPackage getDeploymentPackage() {
		return deploymentPackage;
	}

	public List<Deployable> getDeployables() {
		return deployables;
	}

	public void setDeployables(List<Deployable> deployables) {
		this.deployables = deployables;
	}

	public void addDeployable(Deployable deployable) {
		this.deployables.add(deployable);
	}

	private void createApplicationEntity(PackageInfo packageInfo) {
		application = new Application();
		application.setId(generateId(APPLICATIONS.getRootNodeName(), packageInfo.applicationName));
    }

	private void createDeploymentPackageEntity(PackageInfo packageInfo) {
		deploymentPackage = new DeploymentPackage();
		deploymentPackage.setId(generateId(application, packageInfo.applicationVersion));
		deploymentPackage.setApplication(application);
    }
}
