package com.xebialabs.xlplatform.rest.script

import java.net.URL
import scala.xml.{XML, Elem}
import java.io.InputStream
import com.xebialabs.deployit.booter.local.utils.Closeables

object ResourceUtils {

  def findResources(filePattern: String): Seq[URL] = {
    import collection.convert.wrapAll._
    Thread.currentThread().getContextClassLoader.getResources(filePattern).toSeq
  }

  def loadXmlResources(filePattern: String): List[Elem] = {
    findResources(filePattern).map {
      r =>
        val stream: InputStream = r.openStream()
        try {
          XML.load(stream)
        } finally {
          Closeables.closeQuietly(stream)
        }
    }.toList
  }

}
