/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.spring;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import com.esotericsoftware.kryo.Serializer;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.core.rest.websockets.RemoteChangeSetEventListener$;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskExecutionWorker$;
import com.xebialabs.deployit.engine.tasker.TaskFinalizer;
import com.xebialabs.deployit.engine.tasker.TaskFinalizerImpl;
import com.xebialabs.deployit.engine.tasker.TaskQueueService;
import com.xebialabs.deployit.engine.tasker.TaskerException;
import com.xebialabs.deployit.engine.tasker.distribution.versioning.ConfigurationHashProvider;
import com.xebialabs.deployit.engine.tasker.log.StepLogFactory;
import com.xebialabs.deployit.engine.tasker.log.StepLogRetriever;
import com.xebialabs.deployit.engine.tasker.repository.ActiveTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.CrudTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.engine.tasker.satellite.KryoAkkaSerializer;
import com.xebialabs.deployit.engine.tasker.satellite.KryoCustomizer;
import com.xebialabs.deployit.engine.tasker.satellite.WorkDirSerializer;
import com.xebialabs.deployit.engine.tasker.satellite.WorkDirSerializer$;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.discovery.DiscoveryService;
import com.xebialabs.deployit.service.discovery.DiscoveryWorker$;
import com.xebialabs.deployit.spring.EngineBeanBuilder$;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import com.xebialabs.xlplatform.akka25.Akka25$;
import com.xebialabs.xlplatform.settings.CommonSettings;
import com.xebialabs.xlplatform.settings.TaskerSettings;
import java.io.File;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Configuration
@Lazy
@ScalaSignature(bytes="\u0006\u0001\tEd\u0001B\r\u001b\u0001\rB\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\ti\u0001\u0011\t\u0011)A\u0005Y!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005@\u0001\t\u0005\t\u0015!\u00038\u0011!\u0001\u0005A!b\u0001\n\u0003\t\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b-\u0003A\u0011\u0001'\t\u000f\r\u0004!\u0019!C\u0005I\"11\u000e\u0001Q\u0001\n\u0015Dq\u0001\u001c\u0001C\u0002\u0013=Q\u000e\u0003\u0004w\u0001\u0001\u0006iA\u001c\u0005\no\u0002\u0001\r\u00111A\u0005\u0002aD1\"a\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0006!Q\u0011\u0011\u0003\u0001A\u0002\u0003\u0005\u000b\u0015B=\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002B\u0002\u001f\u0001\t\u0003\t9\bC\u0004\u0002\u0000\u0002!\tA!\u0001\t\u000f\tm\u0001\u0001\"\u0001\u0002$!9!Q\u0005\u0001\u0005\n\t\u001dra\u0002B\u001f5!\u0005!q\b\u0004\u00073iA\tA!\u0011\t\r-3B\u0011\u0001B\"\u0011\u001d\u0011)E\u0006C\u0001\u0005\u000f\u0012\u0011#\u00128hS:,')Z1o\u0005VLG\u000eZ3s\u0015\tYB$\u0001\u0004taJLgn\u001a\u0006\u0003;y\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003?\u0001\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0005\n1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g\u0003%AH\u000eZ\"p]\u001aLw-F\u0001-!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0004d_:4\u0017n\u001a\u0006\u0003cq\tAaY8sK&\u00111G\f\u0002\n12$7i\u001c8gS\u001e\f!\u0002\u001f7e\u0007>tg-[4!\u0003\u001d\t'o\u00195jm\u0016,\u0012a\u000e\t\u0003quj\u0011!\u000f\u0006\u0003um\na\u0001^1tW\u0016\u0014(B\u0001\u001f\u001d\u0003\u0019)gnZ5oK&\u0011a(\u000f\u0002\b\u0003J\u001c\u0007.\u001b<f\u0003!\t'o\u00195jm\u0016\u0004\u0013!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\t!\t\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006A1/\u001a:wS\u000e,7O\u0003\u0002Hw\u0005\u00191\u000f]5\n\u0005%#%!\u0005*fa>\u001c\u0018\u000e^8ss\u001a\u000b7\r^8ss\u0006\u0011\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:!\u0003\u0019a\u0014N\\5u}Q!QjT0b!\tq\u0005!D\u0001\u001b\u0011\u0015Qs\u00011\u0001-Q\ty\u0015\u000b\u0005\u0002S;6\t1K\u0003\u0002U+\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005Y;\u0016a\u00024bGR|'/\u001f\u0006\u00031f\u000bQAY3b]NT!AW.\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001X\u0001\u0004_J<\u0017B\u00010T\u0005%\tU\u000f^8xSJ,G\rC\u00036\u000f\u0001\u0007q\u0007\u000b\u0002`#\")\u0001i\u0002a\u0001\u0005\"\u0012\u0011-U\u0001\u0007Y><w-\u001a:\u0016\u0003\u0015\u0004\"AZ5\u000e\u0003\u001dT!\u0001[.\u0002\u000bMdg\r\u000e6\n\u0005)<'A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\rML8\u000f^3n+\u0005q\u0007CA8u\u001b\u0005\u0001(BA9s\u0003\u0015\t7\r^8s\u0015\u0005\u0019\u0018\u0001B1lW\u0006L!!\u001e9\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\bgf\u001cH/Z7!\u0003-\u0011\u0017m]3X_J\\G)\u001b:\u0016\u0003e\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\u0005%|'\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u0003Y(\u0001\u0002$jY\u0016\fqBY1tK^{'o\u001b#je~#S-\u001d\u000b\u0005\u0003\u000f\ti\u0001E\u0002&\u0003\u0013I1!a\u0003'\u0005\u0011)f.\u001b;\t\u0011\u0005=Q\"!AA\u0002e\f1\u0001\u001f\u00132\u00031\u0011\u0017m]3X_J\\G)\u001b:!Q\u001dq\u0011QCA\u000e\u0003;\u00012AUA\f\u0013\r\tIb\u0015\u0002\u0006-\u0006dW/Z\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003?\tabI>cCN,wk\u001c:l\t&\u0014X0\u0001\u0006j]&$\u0018.\u00197ju\u0016$\"!a\u0002)\u0007=\t9\u0003\u0005\u0003\u0002*\u0005ERBAA\u0016\u0015\r!\u0016Q\u0006\u0006\u0003\u0003_\tQA[1wCbLA!a\r\u0002,\ti\u0001k\\:u\u0007>t7\u000f\u001e:vGR\fQb^8sW\u0016\u0014X*\u00198bO\u0016\u0014HCBA\u001d\u0003\u007f\t\u0019\u0006E\u0002p\u0003wI1!!\u0010q\u0005!\t5\r^8s%\u00164\u0007bBA!!\u0001\u0007\u00111I\u0001\u001ei\u0006\u001c8.\u0012=fGV$\u0018n\u001c8X_J\\WM\u001d*fa>\u001c\u0018\u000e^8ssB!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013\u0001\u00043jgR\u0014\u0018NY;uS>t'bAA'w\u0005\u0019\u0011\r]5\n\t\u0005E\u0013q\t\u0002\u001e)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8X_J\\WM\u001d*fa>\u001c\u0018\u000e^8ss\"9\u0011Q\u000b\tA\u0002\u0005]\u0013!G2p]\u001aLw-\u001e:bi&|g\u000eS1tQB\u0013xN^5eKJ\u0004B!!\u0017\u0002b5\u0011\u00111\f\u0006\u0005\u0003;\ny&\u0001\u0006wKJ\u001c\u0018n\u001c8j]\u001eT1!!\u0013:\u0013\u0011\t\u0019'a\u0017\u00033\r{gNZ5hkJ\fG/[8o\u0011\u0006\u001c\b\u000e\u0015:pm&$WM\u001d\u0015\u0003!EC3\u0001EA5!\u0011\tY'a\u001d\u000e\u0005\u00055$b\u0001+\u0002p)\u0019\u0011\u0011O-\u0002\u000f\r|g\u000e^3yi&!\u0011QOA7\u0005\u0011\u0011U-\u00198\u0015-\u0005e\u0014qPAH\u00033\u000b9,!/\u0002F\u0006U\u0017q\\Aq\u0003G\u00042\u0001OA>\u0013\r\ti(\u000f\u0002\u0014)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\u0005\b\u0003\u0003\u000b\u0002\u0019AAB\u0003Q\t7\r^5wKR\u000b7o\u001b*fa>\u001c\u0018\u000e^8ssB!\u0011QQAF\u001b\t\t9IC\u0002\u0002\nf\n!B]3q_NLGo\u001c:z\u0013\u0011\ti)a\"\u0003)\u0005\u001bG/\u001b<f)\u0006\u001c8NU3q_NLGo\u001c:z\u0011\u001d\t\t*\u0005a\u0001\u0003'\u000bQ\u0003]3oI&tw\rV1tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0002\u0006\u0006U\u0015\u0002BAL\u0003\u000f\u0013Q\u0003U3oI&tw\rV1tWJ+\u0007o\\:ji>\u0014\u0018\u0010C\u0004\u0002\u001cF\u0001\r!!(\u0002!\r|g\u000e^1j]\u0016\u0014h)Y2u_JL\bCBAP\u0003O\u000bY+\u0004\u0002\u0002\"*\u0019q&a)\u000b\u0007\u0005\u0015\u0016,A\u0002k[NLA!!+\u0002\"\nY\"*\\:MSN$XM\\3s\u0007>tG/Y5oKJ4\u0015m\u0019;pef\u0004B!!,\u000246\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019+\u0001\u0005mSN$XM\\3s\u0013\u0011\t),a,\u0003?\u0011+g-Y;mi6+7o]1hK2K7\u000f^3oKJ\u001cuN\u001c;bS:,'\u000fC\u0004\u0002BE\u0001\r!a\u0011\t\u000f\u0005U\u0012\u00031\u0001\u0002:!B\u0011\u0011XA_\u00037\t\u0019\rE\u0002S\u0003\u007fK1!!1T\u0005%\tV/\u00197jM&,'/\t\u0002\u00026!9\u0011qY\tA\u0002\u0005%\u0017AD:uKBdun\u001a$bGR|'/\u001f\t\u0005\u0003\u0017\f\t.\u0004\u0002\u0002N*\u0019\u0011qZ\u001d\u0002\u00071|w-\u0003\u0003\u0002T\u00065'AD*uKBdun\u001a$bGR|'/\u001f\u0005\b\u0003/\f\u0002\u0019AAm\u0003A\u0019H/\u001a9M_\u001e\u0014V\r\u001e:jKZ,'\u000f\u0005\u0003\u0002L\u0006m\u0017\u0002BAo\u0003\u001b\u0014\u0001c\u0015;fa2{wMU3ue&,g/\u001a:\t\u000f\u0005U\u0013\u00031\u0001\u0002X!)!&\u0005a\u0001Y!9\u0011Q]\tA\u0002\u0005\u001d\u0018\u0001\u0005;bg.\fV/Z;f'\u0016\u0014h/[2f!\rA\u0014\u0011^\u0005\u0004\u0003WL$\u0001\u0005+bg.\fV/Z;f'\u0016\u0014h/[2fQ\t\t\u0012\u000bK\u0004\u0012\u0003c\fY\"a>\u0011\t\u0005-\u00141_\u0005\u0005\u0003k\fiGA\u0005EKB,g\u000eZ:P]2\u0012\u0011\u0011`\u0011\u0003\u0003w\f\u0001\"\u001e9he\u0006$WM\u001d\u0015\u0004#\u0005%\u0014\u0001\u00053jg\u000e|g/\u001a:z'\u0016\u0014h/[2f)\u0011\u0011\u0019Aa\u0005\u0011\t\t\u0015!qB\u0007\u0003\u0005\u000fQAA!\u0003\u0003\f\u0005IA-[:d_Z,'/\u001f\u0006\u0004\u0005\u001ba\u0012aB:feZL7-Z\u0005\u0005\u0005#\u00119A\u0001\tESN\u001cwN^3ssN+'O^5dK\"9\u0011Q\u0007\nA\u0002\u0005e\u0002\u0006\u0003B\n\u0003{\u000bY\"a1)\u0005I\t\u0006f\u0001\n\u0002j\u00059A-Z:ue>L\bfA\n\u0003 A!\u0011\u0011\u0006B\u0011\u0013\u0011\u0011\u0019#a\u000b\u0003\u0015A\u0013X\rR3tiJ|\u00170A\bsKN\u001c\u0007.\u001a3vY\u0016$\u0016m]6t)\u0019\t9A!\u000b\u0003,!9\u0011\u0011\u0013\u000bA\u0002\u0005M\u0005B\u0002\u001f\u0015\u0001\u0004\tI\bK\u0002\u0001\u0005_\u0001B!a\u001b\u00032%!!1GA7\u0005\u0011a\u0015M_=)\u0007\u0001\u00119\u0004\u0005\u0003\u0002l\te\u0012\u0002\u0002B\u001e\u0003[\u0012QbQ8oM&<WO]1uS>t\u0017!E#oO&tWMQ3b]\n+\u0018\u000e\u001c3feB\u0011aJF\n\u0003-\u0011\"\"Aa\u0010\u0002'\r\u0014X-\u0019;f/>\u00148.\u001a:NC:\fw-\u001a:\u0015\u0015\u0005e\"\u0011\nB&\u0005\u001b\u00129\u0007C\u0003m1\u0001\u0007a\u000eC\u0004\u0002Ba\u0001\r!a\u0011\t\u000f\t=\u0003\u00041\u0001\u0003R\u0005\t2m\u001c8gS\u001e,(/\u0019;j_:D\u0015m\u001d5\u0011\t\tM#\u0011\r\b\u0005\u0005+\u0012i\u0006E\u0002\u0003X\u0019j!A!\u0017\u000b\u0007\tm#%\u0001\u0004=e>|GOP\u0005\u0004\u0005?2\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0003d\t\u0015$AB*ue&twMC\u0002\u0003`\u0019BqA!\u001b\u0019\u0001\u0004\u0011Y'\u0001\btQ>,H\u000e\u001a(pi\u000eCWO\\6\u0011\u0007\u0015\u0012i'C\u0002\u0003p\u0019\u0012qAQ8pY\u0016\fg\u000e")
public class EngineBeanBuilder {
    private final XldConfig xldConfig;
    private final Archive archive;
    private final RepositoryFactory repositoryAdapter;
    private final Logger logger;
    private final ActorSystem system;
    @Value(value="#{baseWorkDir}")
    private File baseWorkDir;

    public static ActorRef createWorkerManager(ActorSystem actorSystem, TaskExecutionWorkerRepository taskExecutionWorkerRepository, String string, boolean bl) {
        return EngineBeanBuilder$.MODULE$.createWorkerManager(actorSystem, taskExecutionWorkerRepository, string, bl);
    }

    public XldConfig xldConfig() {
        return this.xldConfig;
    }

    public Archive archive() {
        return this.archive;
    }

    public RepositoryFactory repositoryAdapter() {
        return this.repositoryAdapter;
    }

    private Logger logger() {
        return this.logger;
    }

    private final ActorSystem system() {
        return this.system;
    }

    public File baseWorkDir() {
        return this.baseWorkDir;
    }

    public void baseWorkDir_$eq(File x$1) {
        this.baseWorkDir = x$1;
    }

    @PostConstruct
    public void initialize() {
        block0: {
            if (this.xldConfig().inProcessTaskEngine()) break block0;
            ((KryoAkkaSerializer)((Serialization)SerializationExtension$.MODULE$.apply(this.system())).serializerFor(WorkDir.class)).setKryoCustomizers((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KryoCustomizer[]{kryo -> kryo.addDefaultSerializer(WorkDir.class, (Serializer)new WorkDirSerializer(kryo, this.baseWorkDir(), WorkDirSerializer$.MODULE$.$lessinit$greater$default$3()))}));
        }
    }

    @Bean
    @Autowired
    public ActorRef workerManager(TaskExecutionWorkerRepository taskExecutionWorkerRepository, ConfigurationHashProvider configurationHashProvider) {
        return EngineBeanBuilder$.MODULE$.createWorkerManager(this.system(), taskExecutionWorkerRepository, configurationHashProvider.configurationHash(), this.xldConfig().inProcessTaskEngine());
    }

    @Bean
    @DependsOn(value={"upgrader"})
    @Autowired
    public TaskExecutionEngine engine(ActiveTaskRepository activeTaskRepository, PendingTaskRepository pendingTaskRepository, JmsListenerContainerFactory<DefaultMessageListenerContainer> containerFactory, TaskExecutionWorkerRepository taskExecutionWorkerRepository, @Qualifier(value="workerManager") ActorRef workerManager, StepLogFactory stepLogFactory, StepLogRetriever stepLogRetriever, ConfigurationHashProvider configurationHashProvider, XldConfig xldConfig, TaskQueueService taskQueueService) {
        ActorRef actorRef;
        TaskerSettings taskerSettings = new CommonSettings(xldConfig.rootConfig()).tasker();
        TaskFinalizerImpl taskFinalizer = new TaskFinalizerImpl(this.system(), (CrudTaskRepository)activeTaskRepository, pendingTaskRepository, taskerSettings.askTimeout());
        TaskExecutionEngine engine = new TaskExecutionEngine(activeTaskRepository, pendingTaskRepository, taskExecutionWorkerRepository, taskQueueService, this.system(), workerManager, (TaskFinalizer)taskFinalizer);
        if (xldConfig.inProcessTaskEngine()) {
            this.logger().info("An in-process task execution worker will be registered.");
            TaskExecutionWorker$.MODULE$.local(this.repositoryAdapter(), this.archive(), configurationHashProvider, activeTaskRepository, pendingTaskRepository, taskExecutionWorkerRepository, containerFactory, taskerSettings, stepLogFactory, stepLogRetriever, this.system()).recoverTasks();
            DiscoveryWorker$.MODULE$.initialize(this.system());
            actorRef = BoxedUnit.UNIT;
        } else {
            this.logger().debug("Registering for remote change set events.");
            actorRef = this.system().actorOf(RemoteChangeSetEventListener$.MODULE$.props(), RemoteChangeSetEventListener$.MODULE$.name());
        }
        this.rescheduleTasks(pendingTaskRepository, engine);
        return engine;
    }

    @Bean
    @Autowired
    public DiscoveryService discoveryService(@Qualifier(value="workerManager") ActorRef workerManager) {
        return new DiscoveryService(this.system(), workerManager);
    }

    @PreDestroy
    public void destroy() {
        Akka25$.MODULE$.terminate(this.system(), (Duration)Duration$.MODULE$.Inf());
    }

    private void rescheduleTasks(PendingTaskRepository pendingTaskRepository, TaskExecutionEngine engine) {
        pendingTaskRepository.scheduledTasks().forEach(task -> {
            Throwable ex;
            String date = task.getScheduledDate().toDateTimeISO().toString("yyyy-MM-dd'T'HH:mm:ss");
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> engine.schedule(task.getId(), task.getScheduledDate()));
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable ex2 = failure.exception();
                if (ex2 instanceof TaskerException) {
                    TaskerException taskerException = (TaskerException)ex2;
                    this.logger().warn(new StringBuilder(73).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] cannot be rescheduled automatically.").toString());
                    this.logger().warn(taskerException.getMessage());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
            if (bl && (ex = failure.exception()) instanceof Exception) {
                Exception exception = (Exception)ex;
                this.logger().warn(new StringBuilder(100).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] cannot be rescheduled automatically. Unexpected error occurred.").toString());
                throw exception;
            }
            if (!(try_ instanceof Success)) throw new MatchError((Object)try_);
            this.logger().info(new StringBuilder(52).append("Scheduled task [").append(task.getId()).append("] with start date [").append(date).append("] was rescheduled").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    public EngineBeanBuilder(@Autowired XldConfig xldConfig, @Autowired Archive archive, @Autowired RepositoryFactory repositoryAdapter) {
        this.xldConfig = xldConfig;
        this.archive = archive;
        this.repositoryAdapter = repositoryAdapter;
        this.logger = LoggerFactory.getLogger(EngineBeanBuilder.class);
        this.system = TaskActorSystem$.MODULE$.actorSystem();
    }
}

