/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.xebialabs.deployit.checksum.ChecksumAlgorithmProvider;
import com.xebialabs.deployit.core.rest.util.RepositoryHelper;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.CompositePackage;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.Importer;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.DefaultImportingContext;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.XmlManifestDarImporter;
import com.xebialabs.deployit.service.importer.package$;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xldeploy.packager.placeholders.PlaceholdersUtil$;
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry$;
import com.xebialabs.xlplatform.utils.ResourceManagement$;
import de.schlichtherle.truezip.file.TFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\teh\u0001B\u00193\u0001uB\u0001B\u0013\u0001\u0003\u0002\u0004%\ta\u0013\u0005\t%\u0002\u0011\t\u0019!C\u0001'\"AA\f\u0001B\u0001B\u0003&A\n\u0003\u0005^\u0001\t\u0005\r\u0011\"\u0001_\u0011!)\u0007A!a\u0001\n\u00031\u0007\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0015B0\t\u0011%\u0004!\u00111A\u0005\u0002)D\u0001\"\u001d\u0001\u0003\u0002\u0004%\tA\u001d\u0005\ti\u0002\u0011\t\u0011)Q\u0005W\"AQ\u000f\u0001BA\u0002\u0013\u0005a\u000f\u0003\u0006\u0002\u0004\u0001\u0011\t\u0019!C\u0001\u0003\u000bA\u0011\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0015B<\t\u0015\u0005-\u0001A!a\u0001\n\u0003\ti\u0001\u0003\u0006\u0002$\u0001\u0011\t\u0019!C\u0001\u0003KA!\"!\u000b\u0001\u0005\u0003\u0005\u000b\u0015BA\b\u0011)\tY\u0003\u0001BA\u0002\u0013\u0005\u0011Q\u0006\u0005\u000b\u0003w\u0001!\u00111A\u0005\u0002\u0005u\u0002BCA!\u0001\t\u0005\t\u0015)\u0003\u00020!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003\"CA:\u0001\t\u0007I\u0011BA;\u0011!\t\u0019\n\u0001Q\u0001\n\u0005]\u0004\"CAK\u0001\t\u0007I\u0011BAL\u0011!\t)\u000b\u0001Q\u0001\n\u0005e\u0005\"CAT\u0001\t\u0007I\u0011BAU\u0011!\tI\r\u0001Q\u0001\n\u0005-\u0006bCAf\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001bD1\"a7\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002^\"Y\u0011\u0011\u001d\u0001A\u0002\u0003\u0005\u000b\u0015BAh\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003KDq!a>\u0001\t\u0003\nI\u0010C\u0004\u0002|\u0002!\t!!@\t\u000f\t\u0005\u0001\u0001\"\u0011\u0003\u0004!9!Q\u0004\u0001\u0005B\t}\u0001b\u0002B\u0016\u0001\u0011E!Q\u0006\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0011\u001d\u0011I\u0005\u0001C\u0005\u0005\u0017BqA!\u0019\u0001\t\u0013\u0011\u0019\u0007C\u0004\u0003z\u0001!IAa\u001f\t\u000f\t\u0005\u0005\u0001\"\u0003\u0003\u0004\"9!q\u0012\u0001\u0005\n\tE\u0005b\u0002BV\u0001\u0011%!Q\u0016\u0005\b\u0005\u0007\u0004A\u0011\u0002Bc\u0011\u001d\u0011i\r\u0001C\u0005\u0005\u001fDqAa&\u0001\t\u0013\u0011)\u000eC\u0004\u0003Z\u0002!IAa7\t\u000f\t}\u0007\u0001\"\u0003\u0003b\"9!1\u001e\u0001\u0005\n\t5\bb\u0002B\u0016\u0001\u0011%!1\u001f\u0002\u0014\u00136\u0004xN\u001d;feN+'O^5dK&k\u0007\u000f\u001c\u0006\u0003gQ\n\u0001\"[7q_J$XM\u001d\u0006\u0003kY\nqa]3sm&\u001cWM\u0003\u00028q\u0005AA-\u001a9m_fLGO\u0003\u0002:u\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002w\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0010$\u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015\u0001\u00027b]\u001eT\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\n1qJ\u00196fGR\u0004\"a\u0012%\u000e\u0003IJ!!\u0013\u001a\u0003\u001f%k\u0007o\u001c:uKJ\u001cVM\u001d<jG\u0016\f\u0011C]3q_NLGo\u001c:z'\u0016\u0014h/[2f+\u0005a\u0005CA'Q\u001b\u0005q%BA(7\u0003)\u0011X\r]8tSR|'/_\u0005\u0003#:\u0013\u0011CU3q_NLGo\u001c:z'\u0016\u0014h/[2f\u0003U\u0011X\r]8tSR|'/_*feZL7-Z0%KF$\"\u0001\u0016.\u0011\u0005UCV\"\u0001,\u000b\u0003]\u000bQa]2bY\u0006L!!\u0017,\u0003\tUs\u0017\u000e\u001e\u0005\b7\n\t\t\u00111\u0001M\u0003\rAH%M\u0001\u0013e\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0007%A\u0006s_2,7+\u001a:wS\u000e,W#A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t4\u0014\u0001C:fGV\u0014\u0018\u000e^=\n\u0005\u0011\f'a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\fqB]8mKN+'O^5dK~#S-\u001d\u000b\u0003)\u001eDqaW\u0003\u0002\u0002\u0003\u0007q,\u0001\u0007s_2,7+\u001a:wS\u000e,\u0007%A\u0005wC2LG-\u0019;peV\t1\u000e\u0005\u0002m_6\tQN\u0003\u0002oi\u0005Qa/\u00197jI\u0006$\u0018n\u001c8\n\u0005Al'!\u0003,bY&$\u0017\r^8s\u000351\u0018\r\\5eCR|'o\u0018\u0013fcR\u0011Ak\u001d\u0005\b7\"\t\t\u00111\u0001l\u0003)1\u0018\r\\5eCR|'\u000fI\u0001\bg\u000e\fgN\\3s+\u00059\bC\u0001=\u0000\u001b\u0005I(B\u0001>|\u00031\u0001H.Y2fQ>dG-\u001a:t\u0015\taX0\u0001\u0005qC\u000e\\\u0017mZ3s\u0015\tq\b(\u0001\u0005yY\u0012,\u0007\u000f\\8z\u0013\r\t\t!\u001f\u0002\u0016'>,(oY3BeRLg-Y2u'\u000e\fgN\\3s\u0003-\u00198-\u00198oKJ|F%Z9\u0015\u0007Q\u000b9\u0001C\u0004\\\u0017\u0005\u0005\t\u0019A<\u0002\u0011M\u001c\u0017M\u001c8fe\u0002\n\u0001C]3q_NLGo\u001c:z\u0011\u0016d\u0007/\u001a:\u0016\u0005\u0005=\u0001\u0003BA\t\u0003?i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u0005kRLGN\u0003\u0003\u0002\u001a\u0005m\u0011\u0001\u0002:fgRT1!!\b7\u0003\u0011\u0019wN]3\n\t\u0005\u0005\u00121\u0003\u0002\u0011%\u0016\u0004xn]5u_JL\b*\u001a7qKJ\fAC]3q_NLGo\u001c:z\u0011\u0016d\u0007/\u001a:`I\u0015\fHc\u0001+\u0002(!A1LDA\u0001\u0002\u0004\ty!A\tsKB|7/\u001b;pefDU\r\u001c9fe\u0002\n\u0011d\u00195fG.\u001cX/\\!mO>\u0014\u0018\u000e\u001e5n!J|g/\u001b3feV\u0011\u0011q\u0006\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\u001c\u0002\u0011\rDWmY6tk6LA!!\u000f\u00024\tI2\t[3dWN,X.\u00117h_JLG\u000f[7Qe>4\u0018\u000eZ3s\u0003u\u0019\u0007.Z2lgVl\u0017\t\\4pe&$\b.\u001c)s_ZLG-\u001a:`I\u0015\fHc\u0001+\u0002@!A1,EA\u0001\u0002\u0004\ty#\u0001\u000edQ\u0016\u001c7n];n\u00032<wN]5uQ6\u0004&o\u001c<jI\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u000f\u0003\u000f\nI%a\u0013\u0002N\u0005=\u0013\u0011KA*!\t9\u0005\u0001C\u0003K'\u0001\u0007A\nC\u0003^'\u0001\u0007q\fC\u0003j'\u0001\u00071\u000eC\u0003v'\u0001\u0007q\u000fC\u0004\u0002\fM\u0001\r!a\u0004\t\u000f\u0005-2\u00031\u0001\u00020!\u001a1#a\u0016\u0011\t\u0005e\u0013qN\u0007\u0003\u00037RA!!\u0018\u0002`\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005\u0005\u00141M\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\t)'a\u001a\u0002\u000b\t,\u0017M\\:\u000b\t\u0005%\u00141N\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u0011QN\u0001\u0004_J<\u0017\u0002BA9\u00037\u0012\u0011\"Q;u_^L'/\u001a3\u0002\u0013%l\u0007o\u001c:uKJ\u001cXCAA<!\u0019\tI(! \u0002\u00026\u0011\u00111\u0010\u0006\u0004\u0003+\u0011\u0015\u0002BA@\u0003w\u0012A\u0001T5tiB!\u00111QAH\u001b\t\t)IC\u00024\u0003\u000fSA!!#\u0002\f\u0006\u0019\u0011\r]5\u000b\u0007\u00055e'\u0001\u0004tKJ4XM]\u0005\u0005\u0003#\u000b)I\u0001\u0005J[B|'\u000f^3s\u0003)IW\u000e]8si\u0016\u00148\u000fI\u0001\u0007Y><w-\u001a:\u0016\u0005\u0005e\u0005\u0003BAN\u0003Ck!!!(\u000b\t\u0005}\u00151N\u0001\u0006g24GG[\u0005\u0005\u0003G\u000biJ\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003AI7oQ8mY\u0016\u001cG/[8o\u0017&tG-\u0006\u0002\u0002,B9Q+!,\u00022\u0006\r\u0017bAAX-\nIa)\u001e8di&|g.\r\t\u0005\u0003g\u000by,\u0004\u0002\u00026*!\u0011qWA]\u0003\u001d\u0011XM\u001a7fGRTA!!#\u0002<*\u0019\u0011Q\u0018\u001c\u0002\rAdWoZ5o\u0013\u0011\t\t-!.\u0003\u0019A\u0013x\u000e]3sif\\\u0015N\u001c3\u0011\u0007U\u000b)-C\u0002\u0002HZ\u0013qAQ8pY\u0016\fg.A\tjg\u000e{G\u000e\\3di&|gnS5oI\u0002\n!$[7q_J$\u0018M\u00197f!\u0006\u001c7.Y4f\t&\u0014Xm\u0019;pef,\"!a4\u0011\t\u0005E\u0017q[\u0007\u0003\u0003'T1!!6C\u0003\tIw.\u0003\u0003\u0002Z\u0006M'\u0001\u0002$jY\u0016\fa$[7q_J$\u0018M\u00197f!\u0006\u001c7.Y4f\t&\u0014Xm\u0019;pef|F%Z9\u0015\u0007Q\u000by\u000e\u0003\u0005\\7\u0005\u0005\t\u0019AAh\u0003mIW\u000e]8si\u0006\u0014G.\u001a)bG.\fw-\u001a#je\u0016\u001cGo\u001c:zA\u0005i\u0011N\\5u\u00136\u0004xN\u001d;feN$\u0012\u0001\u0016\u0015\u0004;\u0005%\b\u0003BAv\u0003gl!!!<\u000b\t\u0005u\u0013q\u001e\u0006\u0003\u0003c\fQA[1wCbLA!!>\u0002n\ni\u0001k\\:u\u0007>t7\u000f\u001e:vGR\fQdZ3u\u00136\u0004xN\u001d;bE2,\u0007+Y2lC\u001e,G)\u001b:fGR|'/\u001f\u000b\u0003\u0003\u001f\fQd]3u\u00136\u0004xN\u001d;bE2,\u0007+Y2lC\u001e,G)\u001b:fGR|'/\u001f\u000b\u0004)\u0006}\bbBAf?\u0001\u0007\u0011qZ\u0001\rY&\u001cH\u000fU1dW\u0006<Wm\u001d\u000b\u0003\u0005\u000b\u0001b!!\u001f\u0002~\t\u001d\u0001\u0003\u0002B\u0005\u0005/qAAa\u0003\u0003\u0014A\u0019!Q\u0002,\u000e\u0005\t=!b\u0001B\ty\u00051AH]8pizJ1A!\u0006W\u0003\u0019\u0001&/\u001a3fM&!!\u0011\u0004B\u000e\u0005\u0019\u0019FO]5oO*\u0019!Q\u0003,\u0002\u001b%l\u0007o\u001c:u!\u0006\u001c7.Y4f)\u0011\u00119A!\t\t\u000f\t\r\u0012\u00051\u0001\u0003&\u000511o\\;sG\u0016\u0004B!a!\u0003(%!!\u0011FAC\u00051IU\u000e]8siN{WO]2f\u0003=\u0019\u0007.Z2l!\u0016\u0014X.[:tS>tG#\u0002+\u00030\tu\u0002b\u0002B\u0019E\u0001\u0007!1G\u0001\u000ba\u0016\u0014X.[:tS>t\u0007\u0003\u0002B\u001b\u0005si!Aa\u000e\u000b\u0007\tE\u0012-\u0003\u0003\u0003<\t]\"A\u0003)fe6L7o]5p]\"9!q\b\u0012A\u0002\t\u001d\u0011\u0001F8o\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l7/\u0001\u0005e_&k\u0007o\u001c:u)\u0019\u00119A!\u0012\u0003H!9!1E\u0012A\u0002\t\u0015\u0002BB\u001a$\u0001\u0004\t\t)\u0001\ttG\u0006t\u0007\u000b\\1dK\"|G\u000eZ3sgR)AK!\u0014\u0003X!9!q\n\u0013A\u0002\tE\u0013aD5na>\u0014H/\u001a3QC\u000e\\\u0017mZ3\u0011\t\u0005\r%1K\u0005\u0005\u0005+\n)IA\bJ[B|'\u000f^3e!\u0006\u001c7.Y4f\u0011\u001d\u0011I\u0006\na\u0001\u00057\n1a\u0019;y!\u0011\t\u0019I!\u0018\n\t\t}\u0013Q\u0011\u0002\u0011\u00136\u0004xN\u001d;j]\u001e\u001cuN\u001c;fqR\f\u0001D]3t_24X-\u00118e\u000b:\u0014\u0018n\u00195BeRLg-Y2u)\r!&Q\r\u0005\b\u0005O*\u0003\u0019\u0001B5\u00039\u0019x.\u001e:dK\u0006\u0013H/\u001b4bGR\u0004BAa\u001b\u0003v5\u0011!Q\u000e\u0006\u0005\u0005_\u0012\t(\u0001\u0005beRLg-Y2u\u0015\u0011\u0011\u0019(!/\u0002\u0007U$W.\u0003\u0003\u0003x\t5$AD*pkJ\u001cW-\u0011:uS\u001a\f7\r^\u0001\u0016SN\f%\u000f^5gC\u000e$\bK]3F]JL7\r[3e)\u0011\t\u0019M! \t\u000f\t}d\u00051\u0001\u0003j\u0005QA-\u001a9m_f\f'\r\\3\u0002\u001b\rDWmY6J[B|'\u000f^3e)\r!&Q\u0011\u0005\b\u0005\u000f;\u0003\u0019\u0001BE\u0003-\u0001\u0018mY6bO\u0016LeNZ8\u0011\t\u0005\r%1R\u0005\u0005\u0005\u001b\u000b)IA\u0006QC\u000e\\\u0017mZ3J]\u001a|\u0017AD2sK\u0006$X-\u00128uSRLWm\u001d\u000b\b)\nM%Q\u0013BM\u0011\u001d\u0011y\u0005\u000ba\u0001\u0005#BqAa&)\u0001\u0004\t\u0019-A\u0005jgV\u0003xM]1eK\"9!1\u0014\u0015A\u0002\tu\u0015!\u0005;p\u0007J,\u0017\r^3D_2dWm\u0019;peB1\u0011\u0011\u0010BP\u0005GKAA!)\u0002|\t\u00191+\u001a;\u0011\t\t\u0015&qU\u0007\u0003\u0005cJAA!+\u0003r\t\t2i\u001c8gS\u001e,(/\u0019;j_:LE/Z7\u0002-\u0019LG\u000e^3s\u000bbL7\u000f^5oOB\u000b7m[1hKN$BAa,\u0003:B1!\u0011\u0002BY\u0005gKAA!)\u0003\u001cA!\u00111\u0017B[\u0013\u0011\u00119,!.\u0003%A\u0013x\u000e]3sif$Um]2sSB$xN\u001d\u0005\b\u0005wK\u0003\u0019\u0001B_\u0003\u001d1XM]:j_:\u0004BA!*\u0003@&!!\u0011\u0019B9\u0005\u001d1VM]:j_:\fad\u0019:fCR,g*Z:uK\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]&#X-\\:\u0015\u000bQ\u00139Ma3\t\u000f\t%'\u00061\u0001\u0003$\u0006\u00111-\u001b\u0005\b\u00057S\u0003\u0019\u0001BO\u0003!1\u0018\r\\5eCR,Gc\u0001+\u0003R\"9!1[\u0016A\u0002\tu\u0015\u0001\u0003;p\u0007J,\u0017\r^3\u0015\t\u0005\r'q\u001b\u0005\b\u0005\u000fc\u0003\u0019\u0001BE\u0003\u001d\t\u0007\u000f\u001d(b[\u0016$BAa\u0002\u0003^\"9!qQ\u0017A\u0002\t%\u0015AE:vEN#(/\u001b8h\u0003\u001a$XM\u001d'bgR$bAa\u0002\u0003d\n\u001d\bb\u0002Bs]\u0001\u0007!qA\u0001\u0002g\"9!\u0011\u001e\u0018A\u0002\t\u001d\u0011aA:fa\u0006\u00192/\u001e2TiJLgn\u001a\"fM>\u0014X\rT1tiR1!q\u0001Bx\u0005cDqA!:0\u0001\u0004\u00119\u0001C\u0004\u0003j>\u0002\rAa\u0002\u0015\u000bQ\u0013)Pa>\t\u000f\t]\u0005\u00071\u0001\u0002D\"9!q\u0011\u0019A\u0002\t%\u0005")
public class ImporterServiceImpl
implements ImporterService {
    private RepositoryService repositoryService;
    private RoleService roleService;
    private Validator validator;
    private SourceArtifactScanner scanner;
    private RepositoryHelper repositoryHelper;
    private ChecksumAlgorithmProvider checksumAlgorithmProvider;
    private final java.util.List<Importer> importers;
    private final Logger logger;
    private final Function1<PropertyKind, Object> isCollectionKind;
    private File importablePackageDirectory;

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public void repositoryService_$eq(RepositoryService x$1) {
        this.repositoryService = x$1;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public void roleService_$eq(RoleService x$1) {
        this.roleService = x$1;
    }

    public Validator validator() {
        return this.validator;
    }

    public void validator_$eq(Validator x$1) {
        this.validator = x$1;
    }

    public SourceArtifactScanner scanner() {
        return this.scanner;
    }

    public void scanner_$eq(SourceArtifactScanner x$1) {
        this.scanner = x$1;
    }

    public RepositoryHelper repositoryHelper() {
        return this.repositoryHelper;
    }

    public void repositoryHelper_$eq(RepositoryHelper x$1) {
        this.repositoryHelper = x$1;
    }

    public ChecksumAlgorithmProvider checksumAlgorithmProvider() {
        return this.checksumAlgorithmProvider;
    }

    public void checksumAlgorithmProvider_$eq(ChecksumAlgorithmProvider x$1) {
        this.checksumAlgorithmProvider = x$1;
    }

    private java.util.List<Importer> importers() {
        return this.importers;
    }

    private Logger logger() {
        return this.logger;
    }

    private Function1<PropertyKind, Object> isCollectionKind() {
        return this.isCollectionKind;
    }

    private File importablePackageDirectory() {
        return this.importablePackageDirectory;
    }

    private void importablePackageDirectory_$eq(File x$1) {
        this.importablePackageDirectory = x$1;
    }

    @PostConstruct
    public void initImporters() {
        Set importerClasses = Scannit.getInstance().getSubTypesOf(Importer.class);
        this.logger().debug("Found importers: {}", new Object[]{importerClasses});
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(importerClasses).asScala()).filter((Function1 & Serializable & scala.Serializable)cls -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$1(cls)))).foreach((Function1 & Serializable & scala.Serializable)importerClass -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$2(this, importerClass)));
        this.importers().sort((o1, o2) -> o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName()));
        this.importers().add((Importer)new XmlManifestDarImporter(this.repositoryService()));
        this.logger().debug("Importer {} registered.", new Object[]{XmlManifestDarImporter.class});
        this.logger().info("Importers configured in XL Deploy: {}", new Object[]{this.importers()});
    }

    @Override
    public File getImportablePackageDirectory() {
        return this.importablePackageDirectory();
    }

    public void setImportablePackageDirectory(File importablePackageDirectory) {
        this.importablePackageDirectory_$eq(importablePackageDirectory);
    }

    @Override
    public java.util.List<String> listPackages() {
        return Lists.newArrayList((Iterable)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((SeqLike)List$.MODULE$.apply((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.importers()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)importer -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$listPackages$1(importer))).flatMap((Function1 & Serializable & scala.Serializable)importer -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((ListableImporter)importer).list(this.importablePackageDirectory())).asScala()).map((Function1 & Serializable & scala.Serializable)pkgFound -> pkgFound, Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).asJava()));
    }

    @Override
    public String importPackage(ImportSource source) {
        String string;
        try {
            Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.importers()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canHandle(source)));
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new ImporterException("The selected file does not have the expected format for an importable package", new Object[0]);
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Importer importer = (Importer)some.value();
            String string2 = this.doImport(source, importer);
            string = string2;
        }
        finally {
            source.cleanUp();
        }
        return string;
    }

    public void checkPermission(Permission permission, String onConfigurationItems) {
        if (!permission.getPermissionHandler().hasPermission(onConfigurationItems)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)onConfigurationItems);
        }
    }

    private String doImport(ImportSource source, Importer importer) {
        String string;
        DefaultImportingContext ctx = new DefaultImportingContext();
        PackageInfo packageInfo = importer.preparePackage(source, (ImportingContext)ctx);
        try {
            boolean upgrade = this.isUpgrade(packageInfo);
            this.checkPermission(upgrade, packageInfo);
            this.checkImported(packageInfo);
            ImportedPackage importedPackage = importer.importEntities(packageInfo, (ImportingContext)ctx);
            this.scanPlaceholders(importedPackage, ctx);
            HashSet toCreate = Sets.newHashSet();
            this.createEntities(importedPackage, upgrade, toCreate);
            this.validate(toCreate);
            if (upgrade) {
                importedPackage.getVersion().setApplication((Application)this.repositoryService().read(packageInfo.getApplicationId()));
            }
            CreateCisCommand event = new CreateCisCommand((java.util.List)Lists.newArrayList((Iterable)toCreate));
            this.repositoryHelper().publishCommand((RepositoryBaseCommand)event);
            string = importedPackage.getVersion().getId();
        }
        finally {
            importer.cleanUp(packageInfo, (ImportingContext)ctx);
        }
        return string;
    }

    private void scanPlaceholders(ImportedPackage importedPackage, ImportingContext ctx) {
        block0: {
            if (!(importedPackage.getVersion() instanceof DeploymentPackage)) break block0;
            ((java.util.List)ctx.getAttribute("temporaryFiles")).add(new TFile(Files.createTempDir()));
            ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(package$.MODULE$.getAllArtifacts(importedPackage.getDeployables())).asScala()).foreach((Function1 & Serializable & scala.Serializable)sourceArtifact -> {
                ImporterServiceImpl.$anonfun$scanPlaceholders$1(this, sourceArtifact);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void resolveAndEnrichArtifact(SourceArtifact sourceArtifact) {
        try {
            ResourceManagement$.MODULE$.using((Closeable)ArtifactResolverRegistry$.MODULE$.resolve(sourceArtifact), (Function1 & Serializable & scala.Serializable)resolve -> {
                ResourceManagement$.MODULE$.using((Closeable)resolve.openStream(), (Function1 & Serializable & scala.Serializable)is -> {
                    ImporterServiceImpl.$anonfun$resolveAndEnrichArtifact$2($this, sourceArtifact$1, resolve, is);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }
        catch (IOException iOException) {
            throw new ImporterException(new StringBuilder(53).append("Could not open stream of uri ").append(sourceArtifact.getFileUri()).append(" of unresolved artifact ").append(sourceArtifact).toString(), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isArtifactPreEnriched(SourceArtifact deployable) {
        void var2_2;
        boolean isPreEnrichedArtifact = deployable.hasProperty("preScannedPlaceholders") && BoxesRunTime.unboxToBoolean((Object)deployable.getProperty("preScannedPlaceholders"));
        this.logger().info(new StringBuilder(26).append("Artifact ").append(deployable).append(" is ").append((Object)(isPreEnrichedArtifact ? "" : "not")).append(" pre-enriched").toString());
        return (boolean)var2_2;
    }

    private void checkImported(PackageInfo packageInfo) {
        String id = IdGenerator.generateId((String)packageInfo.getApplicationId(), (String)packageInfo.getApplicationVersion());
        if (this.repositoryService().exists(id)) {
            throw new ImporterException("Already imported version %s of application %s", packageInfo.getApplicationVersion(), packageInfo.getApplicationName());
        }
        String dirs = this.subStringBeforeLast(packageInfo.getApplicationId(), "/");
        if (!this.repositoryService().exists(dirs)) {
            throw new ImporterException("The directory structure [%s] specified for the import of application [%s] does not exist.", dirs, this.appName(packageInfo));
        }
    }

    private void createEntities(ImportedPackage importedPackage, boolean isUpgrade, Set<ConfigurationItem> toCreateCollector) {
        Object object = !isUpgrade ? BoxesRunTime.boxToBoolean((boolean)toCreateCollector.add((ConfigurationItem)importedPackage.getApplication())) : BoxedUnit.UNIT;
        Version version = importedPackage.getVersion();
        toCreateCollector.add((ConfigurationItem)version);
        this.filterExistingPackages(version).withFilter((Function1 & Serializable & scala.Serializable)pd -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createEntities$1(this, pd))).foreach((Function1 & Serializable & scala.Serializable)pd -> {
            ImporterServiceImpl.$anonfun$createEntities$2(this, version, toCreateCollector, pd);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Set<PropertyDescriptor> filterExistingPackages(Version version) {
        scala.collection.immutable.Set propertyDescriptors = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(version.getType().getDescriptor().getPropertyDescriptors()).asScala()).toSet();
        return !(version instanceof CompositePackage) ? propertyDescriptors : (scala.collection.immutable.Set)propertyDescriptors.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$filterExistingPackages$1(x$2)));
    }

    private void createNestedConfigurationItems(ConfigurationItem ci, Set<ConfigurationItem> toCreateCollector) {
        Collection propertyDescriptors = ci.getType().getDescriptor().getPropertyDescriptors();
        ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(propertyDescriptors).asScala()).withFilter((Function1 & Serializable & scala.Serializable)propertyDescriptor -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$1(this, propertyDescriptor))).foreach((Function1 & Serializable & scala.Serializable)propertyDescriptor -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$2(this, ci, toCreateCollector, propertyDescriptor);
            return BoxedUnit.UNIT;
        });
    }

    private void validate(Set<ConfigurationItem> toCreate) {
        Seq msgs = (Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(toCreate).asScala()).foldLeft((Object)Seq$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(acc, tc) -> {
            Seq validated = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.validator().validate(tc, (java.util.List)Lists.newArrayList((Iterable)toCreate))).asScala();
            return validated.nonEmpty() ? (Seq)acc.$plus$plus((GenTraversableOnce)validated, Seq$.MODULE$.canBuildFrom()) : acc;
        });
        if (msgs.nonEmpty()) {
            throw new ImporterException("Import failed with the following validation errors %s", msgs.mkString(", "));
        }
    }

    private boolean isUpgrade(PackageInfo packageInfo) {
        boolean bl;
        boolean locationSpecified = packageInfo.getApplicationName().contains("/");
        List applications = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.repositoryService().list(new SearchParameters().setType(Type.valueOf(Application.class)).setName(this.appName(packageInfo)).setAncestor(packageInfo.getApplicationRoot()))).asScala()).toList();
        int n = applications.length();
        switch (n) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                if (locationSpecified) {
                    String string = ((ConfigurationItemData)applications.head()).getId();
                    String string2 = packageInfo.getApplicationId();
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        throw new ImporterException("The manifest contains the path [%s] to import the application into, but the application exists at the path [%s]", packageInfo.getApplicationId(), ((ConfigurationItemData)applications.head()).getId());
                    }
                }
                String appId = ((ConfigurationItemData)applications.head()).getId();
                packageInfo.setDirectories(appId.substring(packageInfo.getApplicationRoot().length(), appId.length() - packageInfo.getApplicationName().length()));
                bl = true;
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(43).append("Found more than 1 [").append(((ConfigurationItemData)applications.head()).getType()).append("] with the same name: [").append(applications.mkString(", ")).append("]").toString());
            }
        }
        return bl;
    }

    private String appName(PackageInfo packageInfo) {
        return this.subStringAfterLast(packageInfo.getApplicationId(), "/");
    }

    private String subStringAfterLast(String s, String sep) {
        return !s.contains(sep) ? s : s.substring(s.lastIndexOf(sep) + sep.length());
    }

    private String subStringBeforeLast(String s, String sep) {
        return !s.contains(sep) ? s : s.substring(0, s.lastIndexOf(sep));
    }

    private void checkPermission(boolean isUpgrade, PackageInfo packageInfo) {
        Permission requiredPermission = isUpgrade ? DeployitPermissions.IMPORT_UPGRADE : DeployitPermissions.IMPORT_INITIAL;
        this.checkPermission(requiredPermission, packageInfo.getApplicationId());
    }

    public static final /* synthetic */ boolean $anonfun$isCollectionKind$1(PropertyKind kind) {
        return kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$initImporters$1(Class cls) {
        if (cls.isInterface()) return false;
        if (Modifier.isAbstract(cls.getModifiers())) return false;
        Class clazz = cls;
        Class<XmlManifestDarImporter> clazz2 = XmlManifestDarImporter.class;
        if (clazz == null) {
            if (clazz2 == null) return false;
            return true;
        } else if (clazz.equals(clazz2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$initImporters$2(ImporterServiceImpl $this, Class importerClass) {
        boolean bl;
        try {
            $this.logger().debug("Importer {} registered.", new Object[]{importerClass});
            bl = $this.importers().add((Importer)importerClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException(new StringBuilder(32).append("Could not instantiate importer: ").append(importerClass).toString(), e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$listPackages$1(Importer importer) {
        return importer instanceof ListableImporter;
    }

    public static final /* synthetic */ void $anonfun$scanPlaceholders$1(ImporterServiceImpl $this, SourceArtifact sourceArtifact) {
        if (ArtifactFileUtils.hasRealOrResolvedFile((Artifact)sourceArtifact)) {
            $this.logger().info("Artifact {} is a resolved artifact", new Object[]{sourceArtifact});
            if (!$this.isArtifactPreEnriched(sourceArtifact)) {
                PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sourceArtifact).addChecksumAndScan($this.scanner(), (Function0 & Serializable & scala.Serializable)() -> $this.checksumAlgorithmProvider().getMessageDigest());
            }
        } else {
            $this.logger().info(new StringBuilder(29).append("Resolving artifact ").append(sourceArtifact).append(" from url ").append(sourceArtifact.getFileUri()).toString());
            $this.resolveAndEnrichArtifact(sourceArtifact);
        }
    }

    public static final /* synthetic */ void $anonfun$resolveAndEnrichArtifact$2(ImporterServiceImpl $this, SourceArtifact sourceArtifact$1, ResolvedArtifactFile resolve$1, InputStream is) {
        if (!$this.isArtifactPreEnriched(sourceArtifact$1)) {
            PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sourceArtifact$1).addChecksumAndScan($this.scanner(), resolve$1.getFileName(), is, (Function0 & Serializable & scala.Serializable)() -> $this.checksumAlgorithmProvider().getMessageDigest());
        }
        sourceArtifact$1.setFile(LocalFile.valueOf((File)new File(resolve$1.getFileName())));
    }

    public static final /* synthetic */ boolean $anonfun$createEntities$1(ImporterServiceImpl $this, PropertyDescriptor pd) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)pd.getKind()));
    }

    public static final /* synthetic */ void $anonfun$createEntities$2(ImporterServiceImpl $this, Version version$1, Set toCreateCollector$1, PropertyDescriptor pd) {
        Collection cis = (Collection)pd.get((ConfigurationItem)version$1);
        toCreateCollector$1.addAll(Sets.newHashSet((Iterable)cis));
        cis.forEach(ci -> $this.createNestedConfigurationItems((ConfigurationItem)ci, toCreateCollector$1));
    }

    public static final /* synthetic */ boolean $anonfun$filterExistingPackages$1(PropertyDescriptor x$2) {
        String string = x$2.getName();
        String string2 = "packages";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$1(ImporterServiceImpl $this, PropertyDescriptor propertyDescriptor) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)propertyDescriptor.getKind()));
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$3(Set toCreateCollector$2, ConfigurationItem embedded) {
        return !toCreateCollector$2.contains(embedded);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$4(ImporterServiceImpl $this, Set toCreateCollector$2, ConfigurationItem embedded) {
        toCreateCollector$2.add(embedded);
        $this.createNestedConfigurationItems(embedded, toCreateCollector$2);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$2(ImporterServiceImpl $this, ConfigurationItem ci$1, Set toCreateCollector$2, PropertyDescriptor propertyDescriptor) {
        ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)propertyDescriptor.get(ci$1)).asScala()).withFilter((Function1 & Serializable & scala.Serializable)embedded -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$3(toCreateCollector$2, embedded))).foreach((Function1 & Serializable & scala.Serializable)embedded -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$4($this, toCreateCollector$2, embedded);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public ImporterServiceImpl(RepositoryService repositoryService, RoleService roleService, Validator validator, SourceArtifactScanner scanner, RepositoryHelper repositoryHelper, ChecksumAlgorithmProvider checksumAlgorithmProvider) {
        this.repositoryService = repositoryService;
        this.roleService = roleService;
        this.validator = validator;
        this.scanner = scanner;
        this.repositoryHelper = repositoryHelper;
        this.checksumAlgorithmProvider = checksumAlgorithmProvider;
        this.importers = Lists.newArrayList();
        this.logger = LoggerFactory.getLogger(ImporterServiceImpl.class);
        this.isCollectionKind = (Function1 & Serializable & scala.Serializable)kind -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$isCollectionKind$1(kind));
    }
}

