/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.deployment.planner.CheckPointManagerListener;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecification;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.service.deployment.RollbackCompletedListener;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.deployit.task.archive.TaskArchive;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001\u0002\b\u0010\u0001iA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!A\u0005A!A!\u0002\u0013I\u0005\"B(\u0001\t\u0003\u0001\u0006\"\u00024\u0001\t\u00039\u0007BB<\u0001\t\u0003y\u0001\u0010C\u0003x\u0001\u0011%Q\u0010C\u0004\u00022\u0001!I!a\r\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J!A\u0011Q\n\u0001\u0005\u0002=\ty\u0005\u0003\u0004;\u0001\u0011%\u0011q\u000f\u0002\u0010%>dGNY1dWN+'O^5dK*\u0011\u0001#E\u0001\u000bI\u0016\u0004Hn\\=nK:$(B\u0001\n\u0014\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001F\u000b\u0002\u0011\u0011,\u0007\u000f\\8zSRT!AF\f\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nQa\u001d7gi)T\u0011AJ\u0001\tOJL'P\u001f7fI&\u0011\u0001f\t\u0002\b\u0019><w-\u001b8h\u0003\u0019)gnZ5oKB\u00111fL\u0007\u0002Y)\u0011QFL\u0001\u0007i\u0006\u001c8.\u001a:\u000b\u0005%\u001a\u0012B\u0001\u0019-\u0005\u001dIUI\\4j]\u0016\f\u0011\u0003Z3qY>LX.\u001a8u'\u0016\u0014h/[2f!\t\u0019D'D\u0001\u0010\u0013\t)tBA\tEKBdw._7f]R\u001cVM\u001d<jG\u0016\f1\u0002^1tW\u0006\u00138\r[5wKB\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\bCJ\u001c\u0007.\u001b<f\u0015\ta4#\u0001\u0003uCN\\\u0017B\u0001 :\u0005-!\u0016m]6Be\u000eD\u0017N^3\u0002!]|'o[3s%\u0016\u0004xn]5u_JL\bCA!G\u001b\u0005\u0011%BA\"E\u00031!\u0017n\u001d;sS\n,H/[8o\u0015\t)e&A\u0002ba&L!a\u0012\"\u0003;Q\u000b7o[#yK\u000e,H/[8o/>\u00148.\u001a:SKB|7/\u001b;pef\fQ\u0003]3oI&tw\rV1tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002K\u001b6\t1J\u0003\u0002MY\u0005Q!/\u001a9pg&$xN]=\n\u00059[%!\u0006)f]\u0012Lgn\u001a+bg.\u0014V\r]8tSR|'/_\u0001\u0007y%t\u0017\u000e\u001e \u0015\rE\u00136\u000bV+W!\t\u0019\u0004\u0001C\u0003*\r\u0001\u0007!\u0006C\u00032\r\u0001\u0007!\u0007C\u00037\r\u0001\u0007q\u0007C\u0003@\r\u0001\u0007\u0001\tC\u0003I\r\u0001\u0007\u0011\n\u000b\u0002\u00071B\u0011\u0011\fZ\u0007\u00025*\u00111\fX\u0001\u000bC:tw\u000e^1uS>t'BA/_\u0003\u001d1\u0017m\u0019;pefT!a\u00181\u0002\u000b\t,\u0017M\\:\u000b\u0005\u0005\u0014\u0017aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\r\f1a\u001c:h\u0013\t)'LA\u0005BkR|w/\u001b:fI\u0006A!o\u001c7mE\u0006\u001c7\u000e\u0006\u0002igB\u0011\u0011\u000e\u001d\b\u0003U:\u0004\"a[\u000f\u000e\u00031T!!\\\r\u0002\rq\u0012xn\u001c;?\u0013\tyW$\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u0014aa\u0015;sS:<'BA8\u001e\u0011\u0015at\u00011\u0001u!\tYS/\u0003\u0002wY\t!A+Y:l\u0003m\u0019'/Z1uKJ{G\u000e\u001c2bG.\u001c\u0006/Z2jM&\u001c\u0017\r^5p]R\u0011\u0011\u0010 \t\u0003WiL!a\u001f\u0017\u0003#Q\u000b7o[*qK\u000eLg-[2bi&|g\u000eC\u0003=\u0011\u0001\u0007A\u000fF\u0003z}~\f\t\u0002C\u0003=\u0013\u0001\u0007A\u000fC\u0004\u0002\u0002%\u0001\r!a\u0001\u0002)A\f'\u000f^5bY\u000e{W.\\5u)JLwmZ3s!\u0011\t)!!\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\tq\u0001\u001d7b]:,'O\u0003\u0002\u0011'%!\u0011qBA\u0004\u0005e\u0019\u0005.Z2l!>Lg\u000e^'b]\u0006<WM\u001d'jgR,g.\u001a:\t\u000f\u0005M\u0011\u00021\u0001\u0002\u0016\u0005Aqo\u001c:l\t&\u00148\u000f\u0005\u0004\u0002\u0018\u0005\u0005\u0012q\u0005\b\u0005\u00033\tiBD\u0002l\u00037I\u0011AH\u0005\u0004\u0003?i\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003G\t)C\u0001\u0003MSN$(bAA\u0010;A!\u0011\u0011FA\u0017\u001b\t\tYC\u0003\u0002M'%!\u0011qFA\u0016\u0005\u001d9vN]6ESJ\f\u0011cZ3u/>\u00148\u000eZ5s\u00072,\u0017M\\3s)\u0011\t)$!\u0010\u0011\t\u0005]\u0012\u0011H\u0007\u0002w%\u0019\u00111H\u001e\u0003+]{'o\u001b3je\u000ecW-\u00198feR\u0013\u0018nZ4fe\"9\u0011q\b\u0006A\u0002\u0005\u0005\u0013aB2p]R,\u0007\u0010\u001e\t\u0004W\u0005\r\u0013bAA#Y\t!B+Y:l\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fAdZ3u\u0007\",7m\u001b)pS:$X*\u00198bO\u0016\u0014H*[:uK:,'\u000f\u0006\u0003\u0002\u0004\u0005-\u0003bBA \u0017\u0001\u0007\u0011\u0011I\u0001\u0012I>\u0004&/\u001a9be\u0016\u0014v\u000e\u001c7cC\u000e\\GCBA)\u0003c\n\u0019\b\u0005\u0003\u0002T\u0005-d\u0002BA+\u0003SrA!a\u0016\u0002h9!\u0011\u0011LA3\u001d\u0011\tY&a\u0019\u000f\t\u0005u\u0013\u0011\r\b\u0004W\u0006}\u0013\"\u0001\r\n\u0005Y9\u0012B\u0001\u000b\u0016\u0013\tI3#\u0003\u0002.]%\u0019\u0011q\u0004\u0017\n\t\u00055\u0014q\u000e\u0002\u0007)\u0006\u001c8.\u00133\u000b\u0007\u0005}A\u0006C\u0003=\u0019\u0001\u0007A\u000f\u0003\u0004\u0002v1\u0001\r!_\u0001\u0016e>dGNY1dWN\u0003XmY5gS\u000e\fG/[8o)\u0011\tI(a \u0011\u0007q\tY(C\u0002\u0002~u\u0011A!\u00168ji\")A(\u0004a\u0001i\"\u001a\u0001!a!\u0011\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fS1!!#a\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003\u001b\u000b9IA\u0005D_6\u0004xN\\3oi\u0002")
public class RollbackService
implements Logging {
    private final IEngine engine;
    private final DeploymentService deploymentService;
    private final TaskExecutionWorkerRepository workerRepository;
    private final PendingTaskRepository pendingTaskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RollbackService rollbackService = this;
        synchronized (rollbackService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public String rollback(Task task) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Going to rollback task ").append(task.getId()).toString());
        TaskSpecification rollbackSpecification = this.createRollbackSpecification(task);
        this.workerRepository.getWorker(task.getWorkerId()).foreach((Function1 & Serializable & scala.Serializable)worker -> $this.pendingTaskRepository.store(rollbackSpecification, (Option)new Some((Object)worker.address())));
        return this.doPrepareRollback(task, rollbackSpecification);
    }

    public TaskSpecification createRollbackSpecification(Task task) {
        TaskExecutionContext context = task.getContext();
        WorkdirCleanerTrigger workdirCleanerTrigger = this.getWorkdirCleaner(context);
        CheckPointManagerListener checkPointManagerListener = this.getCheckPointManagerListener(context);
        TaskSpecification rollbackSpecification = this.createRollbackSpecification(task, checkPointManagerListener, (List<WorkDir>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(workdirCleanerTrigger.getWorkDirs()).asScala()).toList());
        rollbackSpecification.getListeners().add(new RollbackCompletedListener(task.getId()));
        TaskMetadata.putMetadata((TaskSpecification)rollbackSpecification, (String)"taskType", (String)TaskType.ROLLBACK.name());
        TaskMetadata.putMetadata((TaskSpecification)rollbackSpecification, (String)"rollbackTask", (String)task.getId());
        return rollbackSpecification;
    }

    private TaskSpecification createRollbackSpecification(Task task, CheckPointManagerListener partialCommitTrigger, List<WorkDir> workDirs) {
        MultiDeltaSpecification rollbackSpec = partialCommitTrigger.checkpointManager().prepareRollback();
        return this.deploymentService.getTaskFullSpecification(rollbackSpec, task.getWorkDir(), (WorkDir[])workDirs.toArray(ClassTag$.MODULE$.apply(WorkDir.class)));
    }

    private WorkdirCleanerTrigger getWorkdirCleaner(TaskExecutionContext context) {
        String name = WorkdirCleanerTrigger.class.getName();
        return (WorkdirCleanerTrigger)context.getAttribute(name);
    }

    private CheckPointManagerListener getCheckPointManagerListener(TaskExecutionContext context) {
        String name = CheckPointManagerListener.class.getName();
        return (CheckPointManagerListener)context.getAttribute(name);
    }

    public String doPrepareRollback(Task task, TaskSpecification rollbackSpecification) {
        this.engine.prepareRollback(task.getId(), rollbackSpecification);
        this.archive(task);
        return rollbackSpecification.getId();
    }

    private void archive(Task task) {
        TaskExecutionState taskExecutionState = task.getState();
        TaskExecutionState taskExecutionState2 = TaskExecutionState.EXECUTED;
        if (!(taskExecutionState != null ? !taskExecutionState.equals(taskExecutionState2) : taskExecutionState2 != null)) {
            this.engine.archive(task.getId());
        } else if (((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TaskExecutionState[]{TaskExecutionState.STOPPED, TaskExecutionState.ABORTED, TaskExecutionState.FAILED}))).contains((Object)task.getState())) {
            this.engine.cancel(task.getId());
        } else {
            throw new IllegalStateException(new StringBuilder(67).append("Can only rollback a STOPPED, FAILED, ABORTED or EXECUTED task [").append(task.getId()).append(" (").append(task.getState()).append(")]").toString());
        }
    }

    @Autowired
    public RollbackService(IEngine engine, DeploymentService deploymentService, TaskArchive taskArchive, TaskExecutionWorkerRepository workerRepository, PendingTaskRepository pendingTaskRepository) {
        this.engine = engine;
        this.deploymentService = deploymentService;
        this.workerRepository = workerRepository;
        this.pendingTaskRepository = pendingTaskRepository;
        Logging.$init$((Logging)this);
    }
}

