/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.discovery;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.google.common.base.Strings;
import com.xebialabs.deployit.engine.tasker.BlockBuilders$;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskInspectionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.service.discovery.DiscoveryContext;
import com.xebialabs.deployit.service.discovery.DiscoveryMessages;
import com.xebialabs.deployit.service.discovery.DiscoveryResult;
import com.xebialabs.deployit.service.discovery.DiscoveryResultsRetriever$;
import com.xebialabs.deployit.service.discovery.DiscoveryTrigger;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.xlplatform.settings.CommonSettings;
import com.xebialabs.xlplatform.settings.CommonSettings$;
import java.util.concurrent.TimeUnit;
import scala.None$;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M4A\u0001D\u0007\u00011!Aq\u0004\u0001BC\u0002\u0013\u0005\u0001\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003\"\u0011!Q\u0003A!b\u0001\n\u0003Y\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u000bA\u0002A\u0011A\u0019\t\u000fY\u0002!\u0019!C\u0005o!1\u0001\t\u0001Q\u0001\naBq!\u0011\u0001C\u0002\u0013%1\u0006\u0003\u0004C\u0001\u0001\u0006I\u0001\f\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\u0006C\u0002!\tA\u0019\u0002\u0011\t&\u001c8m\u001c<fef\u001cVM\u001d<jG\u0016T!AD\b\u0002\u0013\u0011L7oY8wKJL(B\u0001\t\u0012\u0003\u001d\u0019XM\u001d<jG\u0016T!AE\n\u0002\u0011\u0011,\u0007\u000f\\8zSRT!\u0001F\u000b\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001I\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g-\u0001\u0004tsN$X-\\\u000b\u0002CA\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0006C\u000e$xN\u001d\u0006\u0002M\u0005!\u0011m[6b\u0013\tA3EA\u0006BGR|'oU=ti\u0016l\u0017aB:zgR,W\u000eI\u0001\u000eo>\u00148.\u001a:NC:\fw-\u001a:\u0016\u00031\u0002\"AI\u0017\n\u00059\u001a#\u0001C!di>\u0014(+\u001a4\u0002\u001d]|'o[3s\u001b\u0006t\u0017mZ3sA\u00051A(\u001b8jiz\"2A\r\u001b6!\t\u0019\u0004!D\u0001\u000e\u0011\u0015yR\u00011\u0001\"\u0011\u0015QS\u00011\u0001-\u00039\u0019w.\\7p]N+G\u000f^5oON,\u0012\u0001\u000f\t\u0003syj\u0011A\u000f\u0006\u0003wq\n\u0001b]3ui&twm\u001d\u0006\u0003{M\t!\u0002\u001f7qY\u0006$hm\u001c:n\u0013\ty$H\u0001\bD_6lwN\\*fiRLgnZ:\u0002\u001f\r|W.\\8o'\u0016$H/\u001b8hg\u0002\n\u0011\u0004Z5tG>4XM]=SKN,H\u000e^:SKR\u0014\u0018.\u001a<fe\u0006QB-[:d_Z,'/\u001f*fgVdGo\u001d*fiJLWM^3sA\u0005\u0001\u0002O]3qCJ,G)[:d_Z,'/\u001f\u000b\u0004\u000b6K\u0006C\u0001$L\u001b\u00059%B\u0001%J\u0003\u0019!\u0018m]6fe*\u0011!*E\u0001\u0007K:<\u0017N\\3\n\u00051;%!\u0005+bg.\u001c\u0006/Z2jM&\u001c\u0017\r^5p]\")aJ\u0003a\u0001\u001f\u0006\u00111-\u001b\t\u0003!^k\u0011!\u0015\u0006\u0003%N\u000b1!\u001e3n\u0015\t!V+A\u0002ba&T!AV\t\u0002\rAdWoZ5o\u0013\tA\u0016KA\tD_:4\u0017nZ;sCRLwN\\%uK6DQA\u0017\u0006A\u0002m\u000bqa^8sW\u0012K'\u000f\u0005\u0002]?6\tQL\u0003\u0002_#\u0005Q!/\u001a9pg&$xN]=\n\u0005\u0001l&aB,pe.$\u0015N]\u0001\u0014O\u0016$H)[:d_Z,'/\u001f*fgVdGo\u001d\u000b\u0003G\u001a\u0004\"a\r3\n\u0005\u0015l!a\u0004#jg\u000e|g/\u001a:z%\u0016\u001cX\u000f\u001c;\t\u000b\u001d\\\u0001\u0019\u00015\u0002\rQ\f7o[%e!\tI\u0007O\u0004\u0002k]B\u00111nG\u0007\u0002Y*\u0011QnF\u0001\u0007yI|w\u000e\u001e \n\u0005=\\\u0012A\u0002)sK\u0012,g-\u0003\u0002re\n11\u000b\u001e:j]\u001eT!a\\\u000e")
public class DiscoveryService {
    private final ActorSystem system;
    private final ActorRef workerManager;
    private final CommonSettings commonSettings;
    private final ActorRef discoveryResultsRetriever;

    public ActorSystem system() {
        return this.system;
    }

    public ActorRef workerManager() {
        return this.workerManager;
    }

    private CommonSettings commonSettings() {
        return this.commonSettings;
    }

    private ActorRef discoveryResultsRetriever() {
        return this.discoveryResultsRetriever;
    }

    public TaskSpecification prepareDiscovery(ConfigurationItem ci, WorkDir workDir) {
        DiscoveryContext inspectionContext = new DiscoveryContext();
        inspectionContext.discovered(ci);
        String description = new StringBuilder(14).append("Inspection of ").append(ci.getId()).toString();
        PhaseContainer stepBlock = BlockBuilders$.MODULE$.steps(description, (Option)None$.MODULE$, (List)Nil$.MODULE$).build();
        TaskSpecification spec = new TaskSpecification(description, Permissions.getAuthentication(), workDir, stepBlock, (TaskInspectionContext)inspectionContext, false);
        spec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        spec.getListeners().add(new DiscoveryTrigger(inspectionContext));
        TaskMetadata.putMetadata((TaskSpecification)spec, (String)"taskType", (String)TaskType.INSPECTION.name());
        return spec;
    }

    public DiscoveryResult getDiscoveryResults(String taskId) {
        DiscoveryResult discoveryResult;
        Timeout timeout = Timeout$.MODULE$.apply(10L, TimeUnit.SECONDS);
        try {
            ActorRef qual$1 = package$.MODULE$.ask(this.discoveryResultsRetriever());
            DiscoveryMessages.RetrieveResults x$1 = new DiscoveryMessages.RetrieveResults(taskId);
            Timeout x$2 = timeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            discoveryResult = (DiscoveryResult)((DiscoveryMessages.DiscoveryResultsFound)((Object)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3), (Duration)timeout.duration()))).discoveryResult().get();
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"Could not find any results associated with the id [%s]", (Object[])new Object[]{taskId}));
        }
        return discoveryResult;
    }

    public DiscoveryService(ActorSystem system, ActorRef workerManager) {
        this.system = system;
        this.workerManager = workerManager;
        this.commonSettings = (CommonSettings)CommonSettings$.MODULE$.apply(system);
        this.discoveryResultsRetriever = system.actorOf(DiscoveryResultsRetriever$.MODULE$.props(workerManager, this.commonSettings().inProcessTaskEngine()), DiscoveryResultsRetriever$.MODULE$.name());
    }
}

