/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.discovery;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.google.common.base.Strings;
import com.xebialabs.deployit.engine.tasker.BlockBuilders$;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskInspectionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.service.discovery.DiscoveryContext;
import com.xebialabs.deployit.service.discovery.DiscoveryMessages;
import com.xebialabs.deployit.service.discovery.DiscoveryResult;
import com.xebialabs.deployit.service.discovery.DiscoveryResultsRetriever$;
import com.xebialabs.deployit.service.discovery.DiscoveryTrigger;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.xlplatform.settings.CommonSettings;
import com.xebialabs.xlplatform.settings.CommonSettings$;
import java.util.concurrent.TimeUnit;
import scala.None$;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001b\t\u0001B)[:d_Z,'/_*feZL7-\u001a\u0006\u0003\u0007\u0011\t\u0011\u0002Z5tG>4XM]=\u000b\u0005\u00151\u0011aB:feZL7-\u001a\u0006\u0003\u000f!\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!b\u0001\n\u00031\u0012AB:zgR,W.F\u0001\u0018!\tAR$D\u0001\u001a\u0015\tQ2$A\u0003bGR|'OC\u0001\u001d\u0003\u0011\t7n[1\n\u0005yI\"aC!di>\u00148+_:uK6D\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IaF\u0001\bgf\u001cH/Z7!\u0011!\u0011\u0003A!b\u0001\n\u0003\u0019\u0013!D<pe.,'/T1oC\u001e,'/F\u0001%!\tAR%\u0003\u0002'3\tA\u0011i\u0019;peJ+g\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003%\u000399xN]6fe6\u000bg.Y4fe\u0002BQA\u000b\u0001\u0005\u0002-\na\u0001P5oSRtDc\u0001\u0017/_A\u0011Q\u0006A\u0007\u0002\u0005!)Q#\u000ba\u0001/!)!%\u000ba\u0001I!9\u0011\u0007\u0001b\u0001\n\u0013\u0011\u0014AD2p[6|gnU3ui&twm]\u000b\u0002gA\u0011A'O\u0007\u0002k)\u0011agN\u0001\tg\u0016$H/\u001b8hg*\u0011\u0001\bC\u0001\u000bq2\u0004H.\u0019;g_Jl\u0017B\u0001\u001e6\u00059\u0019u.\\7p]N+G\u000f^5oONDa\u0001\u0010\u0001!\u0002\u0013\u0019\u0014aD2p[6|gnU3ui&twm\u001d\u0011\t\u000fy\u0002!\u0019!C\u0005G\u0005IB-[:d_Z,'/\u001f*fgVdGo\u001d*fiJLWM^3s\u0011\u0019\u0001\u0005\u0001)A\u0005I\u0005QB-[:d_Z,'/\u001f*fgVdGo\u001d*fiJLWM^3sA!)!\t\u0001C\u0001\u0007\u0006\u0001\u0002O]3qCJ,G)[:d_Z,'/\u001f\u000b\u0004\t2C\u0006CA#K\u001b\u00051%BA$I\u0003\u0019!\u0018m]6fe*\u0011\u0011JB\u0001\u0007K:<\u0017N\\3\n\u0005-3%!\u0005+bg.\u001c\u0006/Z2jM&\u001c\u0017\r^5p]\")Q*\u0011a\u0001\u001d\u0006\u00111-\u001b\t\u0003\u001fZk\u0011\u0001\u0015\u0006\u0003#J\u000b1!\u001e3n\u0015\t\u0019F+A\u0002ba&T!!\u0016\u0004\u0002\rAdWoZ5o\u0013\t9\u0006KA\tD_:4\u0017nZ;sCRLwN\\%uK6DQ!W!A\u0002i\u000bqa^8sW\u0012K'\u000f\u0005\u0002\\=6\tAL\u0003\u0002^\r\u0005Q!/\u001a9pg&$xN]=\n\u0005}c&aB,pe.$\u0015N\u001d\u0005\u0006C\u0002!\tAY\u0001\u0014O\u0016$H)[:d_Z,'/\u001f*fgVdGo\u001d\u000b\u0003G\u001a\u0004\"!\f3\n\u0005\u0015\u0014!a\u0004#jg\u000e|g/\u001a:z%\u0016\u001cX\u000f\u001c;\t\u000b\u001d\u0004\u0007\u0019\u00015\u0002\rQ\f7o[%e!\tI\u0007O\u0004\u0002k]B\u00111\u000eE\u0007\u0002Y*\u0011Q\u000eD\u0001\u0007yI|w\u000e\u001e \n\u0005=\u0004\u0012A\u0002)sK\u0012,g-\u0003\u0002re\n11\u000b\u001e:j]\u001eT!a\u001c\t")
public class DiscoveryService {
    private final ActorSystem system;
    private final ActorRef workerManager;
    private final CommonSettings commonSettings;
    private final ActorRef discoveryResultsRetriever;

    public ActorSystem system() {
        return this.system;
    }

    public ActorRef workerManager() {
        return this.workerManager;
    }

    private CommonSettings commonSettings() {
        return this.commonSettings;
    }

    private ActorRef discoveryResultsRetriever() {
        return this.discoveryResultsRetriever;
    }

    public TaskSpecification prepareDiscovery(ConfigurationItem ci, WorkDir workDir) {
        DiscoveryContext inspectionContext = new DiscoveryContext();
        inspectionContext.discovered(ci);
        String description = "Inspection of " + ci.getId();
        PhaseContainer stepBlock = BlockBuilders$.MODULE$.steps(description, (Option)None$.MODULE$, (List)Nil$.MODULE$).build();
        TaskSpecification spec = new TaskSpecification(description, Permissions.getAuthentication(), workDir, stepBlock, (TaskInspectionContext)inspectionContext, false);
        spec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        spec.getListeners().add(new DiscoveryTrigger(inspectionContext));
        TaskMetadata.putMetadata((TaskSpecification)spec, (String)"taskType", (String)TaskType.INSPECTION.name());
        return spec;
    }

    public DiscoveryResult getDiscoveryResults(String taskId) {
        DiscoveryResult discoveryResult;
        Timeout timeout = Timeout$.MODULE$.apply(10L, TimeUnit.SECONDS);
        try {
            ActorRef qual$1 = package$.MODULE$.ask(this.discoveryResultsRetriever());
            DiscoveryMessages.RetrieveResults x$1 = new DiscoveryMessages.RetrieveResults(taskId);
            Timeout x$2 = timeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            discoveryResult = (DiscoveryResult)((DiscoveryMessages.DiscoveryResultsFound)((Object)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3), (Duration)timeout.duration()))).discoveryResult().get();
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"Could not find any results associated with the id [%s]", (Object[])new Object[]{taskId}));
        }
        return discoveryResult;
    }

    public DiscoveryService(ActorSystem system, ActorRef workerManager) {
        this.system = system;
        this.workerManager = workerManager;
        this.commonSettings = (CommonSettings)CommonSettings$.MODULE$.apply(system);
        this.discoveryResultsRetriever = system.actorOf(DiscoveryResultsRetriever$.MODULE$.props(workerManager, this.commonSettings().inProcessTaskEngine()), DiscoveryResultsRetriever$.MODULE$.name());
    }
}

