/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.service.deployment.AbstractChainGenerator;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.DeployedPropertySetter;
import com.xebialabs.deployit.service.deployment.DeploymentContext;
import com.xebialabs.deployit.service.deployment.GeneratedDeployeds;
import com.xebialabs.deployit.service.deployment.ResolvedPlaceholderGenerator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyResolverDeployedGenerator
extends AbstractChainGenerator {
    private final Logger logger = LoggerFactory.getLogger(PropertyResolverDeployedGenerator.class);

    public PropertyResolverDeployedGenerator(DeployedGenerator processor) {
        super(processor);
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        DeployedPropertySetter deployedPropertySetter = deploymentContext.getBeanSupplier().getBean(DeployedPropertySetter.class);
        GeneratedDeployeds generatedDeployeds = this.nextGenerator.generateDeployed(deploymentContext, deployable, container);
        generatedDeployeds.getDeployeds().forEach(deployed -> {
            ConsolidatedDictionary dictionary = deploymentContext.dictionaryFilteredByContainer(container);
            deployedPropertySetter.setProperties((EmbeddedDeployedContainer<?, ?>)deployed, (EmbeddedDeployedContainer<?, ?>)((EmbeddedDeployedContainer)deploymentContext.getExistingDeployedSupplier().getExistingDeployedWithContainer(deployable, container).orElse(null)), dictionary);
            String containerId = deployed.getContainer().getId();
            ResolvedPlaceholderGenerator.addGeneratePlaceholders(deploymentContext.getDeployedApplication(), dictionary, containerId);
        });
        this.logger.debug("'{}' generated following deployeds [{}]", (Object)this.nextGenerator.getClass().getName(), (Object)generatedDeployeds);
        return generatedDeployeds;
    }
}

