/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.websockets.WebSocketChangeSetEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.ProgressLogger;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.service.LicenseService;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="deployitJcrRepositoryService")
public class DeployitJcrRepositoryService
extends JcrRepositoryService {
    @Autowired
    public DeployitJcrRepositoryService(JcrTemplate jcrTemplate, PasswordEncrypter passwordEncrypter, LicenseService licenseService) {
        super(jcrTemplate, passwordEncrypter, licenseService);
    }

    protected void checkMoveAllowed(Type type) {
        if (!type.equals((Object)Type.valueOf(Directory.class))) {
            Checks.checkArgument((!DescriptorRegistry.getDescriptor((Type)type).getRoot().equals((Object)Metadata.ConfigurationItemRoot.NESTED) ? 1 : 0) != 0, (String)"Can only move 'rooted' cis [%s]", (Object[])new Object[]{type});
        }
    }

    protected void checkCopyAllowed(Session session, String toBeCopied, String newId) throws RepositoryException {
        Type toBeCopiedParentType = DeployitJcrRepositoryService.readType((Session)session, (String)DeployitJcrRepositoryService.extractParentId((String)toBeCopied));
        Type newParentType = DeployitJcrRepositoryService.readType((Session)session, (String)DeployitJcrRepositoryService.extractParentId((String)newId));
        Checks.checkArgument((boolean)toBeCopiedParentType.equals((Object)newParentType), (String)"Target parent of copied ci must be of same type as that of the copied item [%s]", (Object[])new Object[]{toBeCopiedParentType});
    }

    public void execute(ChangeSet changeset, ProgressLogger progressLogger) {
        super.execute(changeset, progressLogger);
        EventBusHolder.publish((Object)new WebSocketChangeSetEvent(changeset));
    }
}

