/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployit401ArchivedTaskDateUtcConversion
extends JcrUpgrade {
    private static String pattern = "dd MMM yyyy HH:mm:ss z";
    private static List<String> dateProperties = Lists.newArrayList((Object[])new String[]{"startDate", "completionDate", "lastModificationDate", "scheduledDate"});
    private static final Logger logger = LoggerFactory.getLogger(Deployit401ArchivedTaskDateUtcConversion.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("Starting conversion of Task dates to UTC.");
        Session session = ((RawRepositoryImpl)repository).getSession();
        Node tasks = repository.read("/tasks");
        try {
            NodeIterator nodes = tasks.getNodes();
            this.convertNodes(nodes, tasks.getName(), session, new AtomicInteger(0));
            logger.info("Conversion of Task dates to UTC complete.");
            return true;
        }
        catch (RepositoryException e) {
            logger.error("Failed to convert repository", (Throwable)e);
            return false;
        }
    }

    private void convertNodes(NodeIterator nodeIterator, String parent, Session session, AtomicInteger checkpointCounter) throws RepositoryException {
        while (nodeIterator.hasNext()) {
            Node node2 = nodeIterator.nextNode();
            String nodeId = parent + "/" + node2.getName();
            this.convertNode(node2, nodeId, session, checkpointCounter);
            this.convertNodes(node2.getNodes(), nodeId, session, checkpointCounter);
        }
    }

    private void convertNode(Node node2, String nodeId, Session session, AtomicInteger checkpointCounter) throws RepositoryException {
        logger.debug("Converting date properties on node [{}]", (Object)nodeId);
        boolean converted = false;
        for (String dateProperty : dateProperties) {
            if (!node2.hasProperty(dateProperty)) continue;
            logger.debug("Converting date property [{}:{}]", (Object)nodeId, (Object)dateProperty);
            Property dateProp = node2.getProperty(dateProperty);
            Calendar oldDate = dateProp.getDate();
            if (oldDate == null) {
                logger.warn("Date property [{}:{}] is null and cannot be converted.", (Object)nodeId, (Object)dateProperty);
                continue;
            }
            if (oldDate.getTimeZone().getID().equals("GMT")) continue;
            DateTime utcDateTime = new DateTime((Object)oldDate).toDateTime(DateTimeZone.UTC);
            GregorianCalendar newDate = utcDateTime.toGregorianCalendar();
            logger.info("Converted date property [{}] from [{}] to [{}] on node [{}].", new Object[]{dateProp.getName(), this.format(oldDate), this.format(newDate), nodeId});
            node2.setProperty(dateProperty, (Calendar)newDate);
            converted = true;
        }
        if (converted && checkpointCounter.incrementAndGet() >= 100) {
            logger.info("Taking checkpoint...");
            session.save();
            checkpointCounter.set(0);
        }
    }

    private String format(Calendar date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern, Locale.ENGLISH);
        simpleDateFormat.setTimeZone(date.getTimeZone());
        return simpleDateFormat.format(date.getTime());
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"4.0.1");
    }
}

