/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.CompositePackage;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployable;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.Importer;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.DefaultImportingContext;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.XmlManifestDarImporter;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xlplatform.artifact.ArtifactEnricher;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import nl.javadude.scannit.Scannit;
import nl.javadude.t2bus.EventHandlerStrategy;
import nl.javadude.t2bus.event.strategy.ThrowingRuntimeExceptionHandlerStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ImporterServiceImpl
implements ImporterService {
    private RepositoryService repositoryService;
    private RoleService roleService;
    private Validator validator;
    private File importablePackageDirectory;
    private List<Importer> importers = Lists.newArrayList();
    private static final Logger logger = LoggerFactory.getLogger(ImporterServiceImpl.class);

    @Autowired
    public ImporterServiceImpl(RepositoryService repositoryService, RoleService roleService, Validator validator) {
        this.repositoryService = repositoryService;
        this.roleService = roleService;
        this.validator = validator;
    }

    @PostConstruct
    public void initImporters() {
        Set importers = Scannit.getInstance().getSubTypesOf(Importer.class);
        logger.debug("Found importers: {}", (Object)importers);
        for (Class importer : importers) {
            try {
                if (importer.isInterface() || Modifier.isAbstract(importer.getModifiers()) || importer.equals(XmlManifestDarImporter.class)) continue;
                logger.debug("Importer {} registered.", (Object)importer);
                this.importers.add((Importer)importer.newInstance());
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instantiate importer: " + importer, e);
            }
        }
        Collections.sort(this.importers, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
            }
        });
        this.importers.add((Importer)new XmlManifestDarImporter(this.repositoryService));
        logger.debug("Importer {} registered.", XmlManifestDarImporter.class);
        logger.info("Importers configured in XL Deploy: {}", this.importers);
    }

    public void setImportablePackageDirectory(File importablePackageDirectory) {
        this.importablePackageDirectory = importablePackageDirectory;
    }

    @Override
    public File getImportablePackageDirectory() {
        return this.importablePackageDirectory;
    }

    @Override
    public List<String> listPackages() {
        ArrayList packagesFound = Lists.newArrayList();
        for (Importer importer : this.importers) {
            if (!(importer instanceof ListableImporter)) continue;
            packagesFound.addAll(((ListableImporter)importer).list(this.importablePackageDirectory));
        }
        Collections.sort(packagesFound);
        return packagesFound;
    }

    @Override
    public String importPackage(ImportSource source) {
        try {
            for (Importer importer : this.importers) {
                if (!importer.canHandle(source)) continue;
                String string = this.doImport(source, importer);
                return string;
            }
            throw new ImporterException("The selected file does not have the expected format for an importable package", new Object[0]);
        }
        finally {
            source.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doImport(ImportSource source, Importer importer) {
        DefaultImportingContext ctx = new DefaultImportingContext();
        PackageInfo packageInfo = importer.preparePackage(source, (ImportingContext)ctx);
        try {
            boolean isUpgrade = this.isUpgrade(packageInfo);
            this.checkPermission(isUpgrade, packageInfo);
            this.checkImported(packageInfo);
            ImportedPackage importedPackage = importer.importEntities(packageInfo, (ImportingContext)ctx);
            this.scanPlaceholders(importedPackage, ctx);
            HashSet toCreate = Sets.newHashSet();
            this.createEntities(importedPackage, isUpgrade, toCreate);
            this.validate(toCreate);
            if (isUpgrade) {
                Application application = (Application)this.repositoryService.read(packageInfo.getApplicationId());
                importedPackage.getVersion().setApplication(application);
            }
            CreateCisCommand event = new CreateCisCommand((List)Lists.newArrayList((Iterable)toCreate));
            this.publishCommand((RepositoryBaseCommand)event);
            String string = importedPackage.getVersion().getId();
            return string;
        }
        finally {
            importer.cleanUp(packageInfo, (ImportingContext)ctx);
        }
    }

    private void publishCommand(RepositoryBaseCommand event) {
        ArrayList<String> roles = this.listMyRoles();
        event.setSecurityContext(Permissions.getAuthenticatedUserName(), roles);
        EventBusHolder.publish((Object)event, (EventHandlerStrategy)new ThrowingRuntimeExceptionHandlerStrategy());
    }

    private ArrayList<String> listMyRoles() {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.roleService.getRolesFor(Permissions.getAuthentication()), (Function)new Function<Role, String>(){

            public String apply(Role input) {
                return input.getName();
            }
        }));
    }

    private void scanPlaceholders(ImportedPackage importedPackage, ImportingContext ctx) {
        if (importedPackage.getVersion() instanceof DeploymentPackage) {
            File tempDir = Files.createTempDir();
            ((List)ctx.getAttribute("temporaryFiles")).add(new TFile(tempDir));
            for (Deployable deployable : importedPackage.getDeployables()) {
                if (!(deployable instanceof SourceArtifact)) continue;
                SourceArtifact sourceArtifact = (SourceArtifact)deployable;
                ArtifactEnricher artifactEnricher = new ArtifactEnricher((Artifact)sourceArtifact, new WorkDir((LocalFile)LocalFile.valueOf((File)tempDir)));
                try {
                    artifactEnricher.enrich();
                }
                catch (Exception e) {
                    throw new ImporterException(e);
                }
            }
        }
    }

    private void checkImported(PackageInfo packageInfo) {
        if (this.repositoryService.exists(IdGenerator.generateId((String)packageInfo.getApplicationId(), (String)packageInfo.getApplicationVersion()))) {
            throw new ImporterException("Already imported version %s of application %s", packageInfo.getApplicationVersion(), packageInfo.getApplicationName());
        }
        String dirs = this.subStringBeforeLast(packageInfo.getApplicationId(), "/");
        if (!this.repositoryService.exists(dirs)) {
            throw new ImporterException("The directory structure [%s] specified for the import of application [%s] does not exist.", dirs, this.subStringAfterLast(packageInfo.getApplicationId(), "/"));
        }
    }

    private void createEntities(ImportedPackage importedPackage, boolean isUpgrade, Set<ConfigurationItem> toCreateCollector) {
        if (!isUpgrade) {
            toCreateCollector.add((ConfigurationItem)importedPackage.getApplication());
        }
        Version version = importedPackage.getVersion();
        toCreateCollector.add((ConfigurationItem)version);
        Collection<PropertyDescriptor> propertyDescriptors = this.filterExistingPackages(version);
        propertyDescriptors.stream().forEach(pd -> {
            boolean isListOfCI;
            boolean isSetOfCI = pd.getKind() == PropertyKind.SET_OF_CI;
            boolean bl = isListOfCI = pd.getKind() == PropertyKind.LIST_OF_CI;
            if (isSetOfCI || isListOfCI) {
                Collection cis = (Collection)pd.get((ConfigurationItem)version);
                toCreateCollector.addAll(Sets.newHashSet((Iterable)cis));
                cis.forEach(ci -> this.createNestedConfigurationItems((ConfigurationItem)ci, toCreateCollector));
            }
        });
    }

    private Collection<PropertyDescriptor> filterExistingPackages(Version version) {
        Collection propertyDescriptors = version.getType().getDescriptor().getPropertyDescriptors();
        if (version instanceof CompositePackage) {
            return propertyDescriptors.stream().filter(pd -> !pd.getName().equals("packages")).collect(Collectors.toSet());
        }
        return propertyDescriptors;
    }

    private void createNestedConfigurationItems(ConfigurationItem ci, Set<ConfigurationItem> toCreateCollector) {
        Collection propertyDescriptors = ci.getType().getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            boolean isListOfCI;
            boolean isSetOfCI = propertyDescriptor.getKind() == PropertyKind.SET_OF_CI;
            boolean bl = isListOfCI = propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI;
            if (!isSetOfCI && (!isListOfCI || !propertyDescriptor.getReferencedType().getDescriptor().isAssignableTo(EmbeddedDeployable.class))) continue;
            Collection embeddeds = (Collection)propertyDescriptor.get(ci);
            for (ConfigurationItem embedded : embeddeds) {
                if (toCreateCollector.contains(embedded)) continue;
                toCreateCollector.add(embedded);
                this.createNestedConfigurationItems(embedded, toCreateCollector);
            }
        }
    }

    private void validate(Set<ConfigurationItem> toCreate) {
        ArrayList msgs = Lists.newArrayList();
        for (ConfigurationItem toCreateEntity : toCreate) {
            msgs.addAll(this.validator.validate(toCreateEntity, (List)Lists.newArrayList(toCreate)));
        }
        if (!msgs.isEmpty()) {
            throw new ImporterException("Import failed with the following validation errors %s", ((Object)msgs).toString());
        }
    }

    private boolean isUpgrade(PackageInfo packageInfo) {
        String appId = null;
        String appName = this.subStringAfterLast(packageInfo.getApplicationName(), "/");
        boolean locationSpecified = packageInfo.getApplicationName().contains("/");
        List applications = this.repositoryService.list(new SearchParameters().setType(Type.valueOf(Application.class)).setName(appName).setAncestor(packageInfo.getApplicationRoot()));
        for (ConfigurationItemData application : applications) {
            Preconditions.checkState((appId == null ? 1 : 0) != 0, (String)"Found more than 1 [%s] with the same name: [%s] and [%s]", (Object[])new Object[]{application.getType(), appId, application});
            appId = application.getId();
        }
        if (appId != null) {
            if (locationSpecified && !appId.equals(packageInfo.getApplicationId())) {
                throw new ImporterException("The manifest contains the path [%s] to import the application into, but the application exists at the path [%s]", packageInfo.getApplicationId(), appId);
            }
            packageInfo.setDirectories(appId.substring(packageInfo.getApplicationRoot().length(), appId.length() - packageInfo.getApplicationName().length()));
            return true;
        }
        return false;
    }

    private String subStringAfterLast(String s, String sep) {
        if (s.contains(sep)) {
            return s.substring(s.lastIndexOf(sep) + sep.length());
        }
        return s;
    }

    private String subStringBeforeLast(String s, String sep) {
        if (s.contains(sep)) {
            return s.substring(0, s.lastIndexOf(sep));
        }
        return s;
    }

    private void checkPermission(boolean isUpgrade, PackageInfo packageInfo) {
        if (isUpgrade) {
            this.checkPermission(DeployitPermissions.IMPORT_UPGRADE, packageInfo.getApplicationId());
        } else {
            this.checkPermission(DeployitPermissions.IMPORT_INITIAL, packageInfo.getApplicationId());
        }
    }

    void checkPermission(Permission permission, String onConfigurationItems) {
        if (!permission.getPermissionHandler().hasPermission(onConfigurationItems)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)onConfigurationItems);
        }
    }
}

