/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.io.Exploder;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.util.DevNull;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployit394Checksums
extends JcrUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(Deployit394Checksums.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        Type type = Type.valueOf(DeployableArtifact.class);
        Collection subtypes = DescriptorRegistry.getSubtypes((Type)type);
        for (Type subtype : subtypes) {
            try {
                this.upgradeNodesOfType(repository, subtype);
            }
            catch (IOException | RepositoryException e) {
                throw new UpgradeException("Upgrade failed due to", (Exception)e);
            }
        }
        return true;
    }

    private void upgradeNodesOfType(RawRepository repository, Type type) throws RepositoryException, IOException {
        if (!type.getDescriptor().isVirtual()) {
            logger.info("Reading all nodes of type [{}]", (Object)type);
            List nodesByType = repository.findNodesByType(type);
            for (Node node2 : nodesByType) {
                this.upgradeNode(type, node2);
            }
        }
    }

    private void upgradeNode(Type type, Node node2) throws RepositoryException, IOException {
        if (node2.hasProperty("checksum")) {
            logger.debug("Checking whether checksum of [{}] is broken", (Object)node2.getPath());
            String checksum = node2.getProperty("checksum").getString();
            if (this.isPossiblyCorrupt(checksum)) {
                logger.debug("Checksum [{}] of node [{}] needs verification", (Object)checksum, (Object)node2.getPath());
                String realChecksum = this.calculateRealChecksum(type, node2);
                if (this.isReallyCorrupt(checksum, realChecksum)) {
                    logger.info("Fixing checksum [{}] of node [{}] to [{}]", new Object[]{checksum, node2.getPath(), realChecksum});
                    node2.setProperty("checksum", realChecksum);
                }
            }
        } else {
            logger.debug("Skipping node [{}] as it has no checksum", (Object)node2.getPath());
        }
    }

    private String calculateRealChecksum(Type type, Node node2) throws IOException {
        MessageDigest sha1 = JavaCryptoUtils.getSha1();
        Supplier<InputStream> inputSupplier = this.getByteSource(node2);
        if (type.isSubTypeOf(Type.valueOf(FolderArtifact.class))) {
            Exploder.calculateCheckSum(inputSupplier, (MessageDigest)sha1);
        } else {
            try (InputStream input = inputSupplier.get();){
                ByteStreams.copy((InputStream)new DigestInputStream(input, sha1), (OutputStream)new DevNull());
            }
        }
        return JavaCryptoUtils.digest((MessageDigest)sha1);
    }

    private Supplier<InputStream> getByteSource(Node node2) {
        return () -> {
            try {
                return node2.getProperty("$data").getBinary().getStream();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @VisibleForTesting
    boolean isReallyCorrupt(String checksum, String realChecksum) {
        char[] checksumChars = checksum.toCharArray();
        char[] realChecksumChars = realChecksum.toCharArray();
        for (int i = 0; i < checksumChars.length; ++i) {
            char checksumChar = checksumChars[i];
            char realChecksumChar = realChecksumChars[i];
            if (checksumChar == realChecksumChar) continue;
            if (realChecksumChar == '0') {
                realChecksumChar = realChecksumChars[i + 1];
                return checksumChar == realChecksumChar;
            }
            return false;
        }
        return false;
    }

    @VisibleForTesting
    boolean isPossiblyCorrupt(String checksum) {
        return checksum.matches("^[0-9A-Fa-f]{20,39}$");
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"3.9.4");
    }
}

