/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.service.deployment.DeployedApplicationFactory;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.DeployedProcessorsFactory;
import com.xebialabs.deployit.service.deployment.DeploymentContext;
import com.xebialabs.deployit.service.deployment.GeneratedDeployeds;
import com.xebialabs.deployit.service.replacement.Dictionaries;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedService {
    private final DeployedApplicationFactory deployedApplicationFactory;
    private final DeployedProcessorsFactory deployedProcessorsFactory;
    private static final Logger logger = LoggerFactory.getLogger(DeployedService.class);

    @Autowired
    public DeployedService(DeployedApplicationFactory deployedApplicationFactory, DeployedProcessorsFactory deployedProcessorsFactory) {
        this.deployedApplicationFactory = deployedApplicationFactory;
        this.deployedProcessorsFactory = deployedProcessorsFactory;
    }

    public DeployedApplication generateDeployedApplication(Type deployedApplicationType, Version version, Environment env, Map<String, String> userProvidedPlaceholder) {
        Dictionaries dictionaries = Dictionaries.of((List)env.getDictionaries()).filterBy(version.getApplication()).withAdditionalEntries(userProvidedPlaceholder);
        return this.deployedApplicationFactory.createDeployedApplication(deployedApplicationType, version, env, dictionaries.consolidate());
    }

    public GeneratedDeployeds generateSelectedDeployeds(DeployedApplication deployedApplication, List<ConfigurationItem> deployableCis, Version version, Environment env) {
        return this.generateSelectedDeployeds(deployedApplication, deployableCis, env.getMembers(), Dictionaries.of((List)env.getDictionaries()).filterBy(version.getApplication()));
    }

    public GeneratedDeployeds generateSelectedDeployeds(DeployedApplication deployedApplication, List<ConfigurationItem> deployableCis, Set<? extends Container> containers, Dictionaries dictionaries) {
        List deployables = Lists.transform(deployableCis, from -> {
            Checks.checkArgument((boolean)(from instanceof Deployable), (String)"The entity %s is not a deployable", (Object[])new Object[]{from.getId()});
            return (Deployable)from;
        });
        return this.generateDeployedsOfType(deployedApplication, deployables, containers, null, dictionaries);
    }

    public GeneratedDeployeds createSelectedDeployed(DeployedApplication deployedApplication, Deployable deployable, Container container, Type deployedType, Version version, Environment env) {
        logger.debug("Creating deployed for [{}] and [{}]", (Object)deployable, (Object)container);
        Dictionaries dictionaries = Dictionaries.of((List)env.getDictionaries()).filterBy(version.getApplication());
        return this.generateDeployedsOfType(deployedApplication, Lists.newArrayList((Object[])new Deployable[]{deployable}), Lists.newArrayList((Object[])new Container[]{container}), deployedType, dictionaries, true);
    }

    public GeneratedDeployeds generateUpgradedDeployeds(DeployedApplication deployedApplication, Version newPackage, DeployedApplication previousDeployedApplication) {
        Environment environment = previousDeployedApplication.getEnvironment();
        GeneratedDeployeds generatedDeployeds = new GeneratedDeployeds();
        Dictionaries dictionaries = Dictionaries.of((List)environment.getDictionaries()).filterBy(newPackage.getApplication());
        DeploymentContext deploymentContext = this.deployedProcessorsFactory.createContextForUpgrade(deployedApplication, dictionaries, previousDeployedApplication.getDeployeds());
        DeployedGenerator deployedGenerator = this.deployedProcessorsFactory.createUpgradeDeployedGenerator();
        Set containers = previousDeployedApplication.getDeployeds().stream().map(Deployed::getContainer).collect(Collectors.toSet());
        newPackage.getDeployables().stream().forEach(d -> {
            for (Container container : containers) {
                generatedDeployeds.merge(deployedGenerator.generateDeployed(deploymentContext, (Deployable)d, container));
            }
        });
        return generatedDeployeds;
    }

    public DeployedApplication generateUpdateDeployedApplication(DeployedApplication deployedApplication, Version newVersion) {
        logger.debug("Creating upgrade deployed application from: [{}] with new version [{}]", (Object)deployedApplication, (Object)newVersion);
        Dictionaries dictionaries = Dictionaries.of((List)deployedApplication.getEnvironment().getDictionaries()).filterBy(newVersion.getApplication());
        return this.deployedApplicationFactory.createUpgradeDeployedApplication(newVersion, deployedApplication, dictionaries.consolidate());
    }

    public List<Deployed> createDeployedsForNonExistingCombinations(DeployedApplication deployedApplication, Version version, Environment environment, Set<Deployed> deployeds, Map<String, String> userProvidedPlaceholder) {
        Set deployables = version.getDeployables();
        Set members = environment.getMembers();
        List<Deployed> validExistingDeployeds = deployeds.stream().filter(input -> input.getDeployable() != null).collect(Collectors.toList());
        logger.debug("Valid existing deployeds: {}", validExistingDeployeds);
        List invalidExistingDeployeds = deployeds.stream().filter(input -> input.getDeployable() == null).collect(Collectors.toList());
        logger.debug("Invalid existing deployeds: {}", invalidExistingDeployeds);
        FilterSet filterSet = new FilterSet(validExistingDeployeds);
        Dictionaries dictionaries = Dictionaries.of((List)environment.getDictionaries()).filterBy(version.getApplication()).withAdditionalEntries(userProvidedPlaceholder);
        GeneratedDeployeds generatedDeployeds = this.generateDeployedsOfType(deployedApplication, deployables, members, null, dictionaries);
        logger.debug("Going to filter previously present deployeds");
        generatedDeployeds.getDeployeds().forEach(filterSet::add);
        List<Deployed> allValidAsList = filterSet.getAllValidAsList();
        allValidAsList.addAll(invalidExistingDeployeds);
        return allValidAsList;
    }

    private GeneratedDeployeds generateDeployedsOfType(DeployedApplication deployedApplication, Collection<? extends Deployable> deployables, Collection<? extends Container> containers, Type deployedType, Dictionaries dictionaries) {
        return this.generateDeployedsOfType(deployedApplication, deployables, containers, deployedType, dictionaries, false);
    }

    private GeneratedDeployeds generateDeployedsOfType(DeployedApplication deployedApplication, Collection<? extends Deployable> deployables, Collection<? extends Container> containers, Type deployedType, Dictionaries dictionaries, boolean ignoreTags) {
        GeneratedDeployeds generatedDeployeds = new GeneratedDeployeds();
        DeployedGenerator deployedGenerator = ignoreTags ? this.deployedProcessorsFactory.createCoreDeployedGenerator() : this.deployedProcessorsFactory.createTagDeployedGenerator();
        DeploymentContext deploymentContext = deployedType != null ? this.deployedProcessorsFactory.createContextForSpecificType(deployedApplication, dictionaries, deployedType) : this.deployedProcessorsFactory.createContextWithCalculatedType(deployedApplication, dictionaries);
        for (Deployable deployable : deployables) {
            for (Container container : containers) {
                generatedDeployeds.merge(deployedGenerator.generateDeployed(deploymentContext, deployable, container));
            }
        }
        return generatedDeployeds;
    }

    public void scanMissingPlaceholders(DeployedApplication deployedApplication, Environment environment) {
        this.deployedApplicationFactory.scanMissingPlaceholders(deployedApplication, environment);
    }

    private static class Key {
        private String deployableId;
        private String containerId;

        private Key(String deployableId, String containerId) {
            this.deployableId = deployableId;
            this.containerId = containerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.containerId.equals(key.containerId) && this.deployableId.equals(key.deployableId);
        }

        public int hashCode() {
            int result = this.deployableId.hashCode();
            result = 31 * result + this.containerId.hashCode();
            return result;
        }
    }

    private static class Value {
        private Deployed deployed;
        private boolean valid;

        private Value(Deployed deployed) {
            this.deployed = deployed;
        }

        Value valid() {
            this.valid = true;
            return this;
        }

        private boolean isValid() {
            return this.valid;
        }
    }

    private static class FilterSet {
        private Function<Deployed, Key> KEY_FUNC = input -> new Key(input.getDeployable().getId(), input.getContainer().getId());
        private Map<Key, Value> map = Maps.newHashMap();

        public FilterSet(Collection<Deployed> initialDeployeds) {
            for (Deployed initialDeployed : initialDeployeds) {
                this.map.put((Key)this.KEY_FUNC.apply((Object)initialDeployed), new Value(initialDeployed));
            }
        }

        public void add(ConfigurationItem ci) {
            Value v;
            Deployed deployed = (Deployed)ci;
            Key k = (Key)this.KEY_FUNC.apply((Object)deployed);
            Value previous = this.map.put(k, v = new Value(deployed).valid());
            if (previous != null) {
                logger.debug("Filtering out [{}] because it is already present.", (Object)deployed);
                this.map.put(k, previous.valid());
            }
        }

        public List<Deployed> getAllValidAsList() {
            return this.map.values().stream().filter(rec$ -> ((Value)rec$).isValid()).map(value -> ((Value)value).deployed).collect(Collectors.toList());
        }
    }
}

