/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.source;

import com.google.common.base.Strings;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.importer.source.FileSource;
import com.xebialabs.deployit.util.GuavaFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlSource
implements ImportSource {
    private static final Logger logger = LoggerFactory.getLogger(UrlSource.class);
    private static final String CONTENT_DISPOSITION = "Content-disposition";
    private static final String ATTACHMENT = "attachment";
    private static final String FILENAME = "filename";
    private final URL location;
    private final String user;
    private final String password;
    private FileSource downloaded;
    private File tempDir;

    public UrlSource(URL location, String user, String password) {
        this.location = location;
        this.user = user;
        this.password = password;
    }

    public File getFile() {
        if (this.downloaded == null) {
            this.download();
        }
        return this.downloaded.getFile();
    }

    public void cleanUp() {
        if (this.downloaded != null) {
            this.downloaded.cleanUp();
        }
        if (this.tempDir != null) {
            GuavaFiles.deleteQuietly((File)this.tempDir);
        }
    }

    private void download() {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpClientContext context = this.configureAuthentication();
            logger.debug("Preparing to download package from {}", (Object)this.location);
            URI uri = this.location.toURI();
            HttpResponse response = this.executeGetRequest((HttpClient)client, (HttpContext)context, uri);
            URI finalURI = this.getFinalUri(context, uri);
            String fileName = this.getFileName(response, finalURI);
            this.saveFile(response, fileName);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    protected URI getFinalUri(HttpClientContext context, URI uri) throws URISyntaxException {
        return URIUtils.resolve((URI)uri, (HttpHost)context.getTargetHost(), (List)context.getRedirectLocations());
    }

    protected HttpResponse executeGetRequest(HttpClient client, HttpContext context, URI uri) throws IOException {
        HttpGet get = new HttpGet(uri);
        HttpResponse response = client.execute((HttpUriRequest)get, context);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new RuntimeIOException("Failed to download package,status=" + statusCode + ", from url " + this.location);
        }
        return response;
    }

    private HttpClientContext configureAuthentication() {
        HttpClientContext context = HttpClientContext.create();
        if (this.user != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.user, this.password));
            context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(new HttpHost(this.location.getHost(), this.location.getPort(), this.location.getProtocol()), (AuthScheme)new BasicScheme());
            context.setAuthCache((AuthCache)authCache);
        }
        return context;
    }

    private void saveFile(HttpResponse response, String fileName) throws IOException {
        try (InputStream in = response.getEntity().getContent();){
            this.tempDir = Files.createTempDir();
            File archive2 = new File(this.tempDir, fileName);
            Files.asByteSink((File)archive2, (FileWriteMode[])new FileWriteMode[0]).writeFrom(in);
            this.downloaded = new FileSource(archive2, true);
            logger.debug("Successfully downloaded file {}", (Object)this.downloaded.getFile().getName());
        }
    }

    private String getFileName(HttpResponse response, URI finalURI) {
        String filename = this.getFilenameFromHeader(response.getLastHeader(CONTENT_DISPOSITION));
        if (filename == null) {
            logger.trace("File name could not be resolved through 'Content-disposition' header");
            filename = this.getFileNameFromPath(finalURI.getPath());
        }
        logger.debug("File name resolved as {}", (Object)filename);
        return filename;
    }

    private String getFilenameFromHeader(Header contentDisposition) {
        if (contentDisposition != null) {
            for (HeaderElement element : contentDisposition.getElements()) {
                if (!element.getName().equalsIgnoreCase(ATTACHMENT)) continue;
                NameValuePair filenameParam = element.getParameterByName(FILENAME);
                return filenameParam != null ? Strings.emptyToNull((String)filenameParam.getValue()) : null;
            }
        }
        return null;
    }

    private String getFileNameFromPath(String path) {
        logger.trace("Getting target file name from path {}", (Object)path);
        return new File(path).getName();
    }

    public String toString() {
        return "UrlSource[" + this.location + "]";
    }
}

