/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr.grouping;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.jcr.grouping.Function;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupBy {
    private final List<Function<?>> functions;
    private final Map<String, Map<String, Object>> result = Maps.newHashMap();
    private final Set<String> propertyNames;
    private final Map<String, Field> fields;

    public GroupBy(Collection<String> properties, Function<?> ... functions) {
        this.fields = this.getFields(properties);
        this.propertyNames = Sets.newTreeSet(properties);
        this.functions = functions != null ? Lists.newArrayList((Object[])functions) : Lists.newArrayList();
    }

    private Map<String, Field> getFields(Collection<String> properties) {
        HashMap fields = Maps.newHashMap();
        for (String property : properties) {
            try {
                Field field = ArchivedTask.class.getDeclaredField(property);
                field.setAccessible(true);
                fields.put(property, field);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return fields;
    }

    public void process(ArchivedTask task) {
        String key = this.buildKey(task);
        HashMap newRow = this.result.get(key);
        if (newRow == null) {
            newRow = Maps.newHashMap();
            for (String property : this.propertyNames) {
                try {
                    newRow.put(property, this.getPropertyValue(task, property));
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            this.result.put(key, newRow);
        }
        this.executeFunctions(task, key, newRow);
    }

    private Object getPropertyValue(ArchivedTask task, String property) throws IllegalAccessException {
        Field field = this.fields.get(property);
        if (field != null) {
            return field.get(task);
        }
        return task.getMetadata().get(property);
    }

    private String buildKey(ArchivedTask task) {
        ArrayList keyParts = Lists.newArrayList();
        for (String property : this.propertyNames) {
            try {
                keyParts.add(this.getPropertyValue(task, property).toString());
            }
            catch (Exception exception) {}
        }
        String key = Joiner.on((String)"_").join((Iterable)keyParts);
        return key;
    }

    private void executeFunctions(ArchivedTask task, String key, Map<String, Object> newRow) {
        for (Function<?> function : this.functions) {
            newRow.put(function.getName(), function.invoke(newRow.get(function.getName()), task));
        }
    }

    public Collection<Map<String, Object>> getResult() {
        return this.result.values();
    }
}

