package com.xebialabs.deployit.task.archive

import javax.jcr.Node

import com.xebialabs.deployit.engine.api.execution.StepState
import com.xebialabs.deployit.jcr.JcrUtils.getProperty
import com.xebialabs.deployit.task.archive.BlockType.STEP_BLOCK
import com.xebialabs.deployit.task.archive.NodeNames._

import scala.collection.convert.wrapAll._
import scala.collection.mutable.ListBuffer

object StepBlockReader {
  def unapply(blockNode: Node): Option[BlockReader] = if (blockNode.hasProperty(BLOCK_TYPE) && getProperty(blockNode, BLOCK_TYPE).equals(STEP_BLOCK.name()))
    Some(new StepBlockReader)
  else None
}

class StepBlockReader extends BlockReader {

  override def read(blockNode: Node, loadSteps: Boolean, uptodateModel: Boolean): ArchivedStepBlock = {
    val block = new ArchivedStepBlock()
    readBasicBlockProperties(blockNode, block, uptodateModel)
    if (loadSteps) {
      block.setSteps(getSteps(blockNode, loadSteps, uptodateModel))
    }
    block
  }

  private def getSteps(blockNode: Node, loadSteps: Boolean, uptodateModel: Boolean): Seq[StepState] = {
    val steps = ListBuffer.empty[StepState]
    val nodes = blockNode.getNodes
    while (nodes.hasNext) {
      steps += new StepReader().read(nodes.nextNode(), loadSteps, uptodateModel)
    }
    steps
  }

  override def readFirstBlock(taskNode: Node, loadSteps: Boolean): ArchivedPhaseContainer = {
    val firstBlock = read(taskNode, loadSteps, BlockReader.DEPRECATED_MODEL)
    wrapInPhaseContainer(firstBlock)
  }
}