package com.xebialabs.deployit.task.archive

object ConfigurationId {

  def encode(id: String): ConfigurationId = {
    val correctedId = if (id.startsWith(CONFIGURATION_ROOT))
      id.substring(CONFIGURATION_ROOT.length)
    else id

    correctedId.replace("/", "$#")
  }

  def decode(id: String): ConfigurationId = {
    val converted = id.replace("$#", "/")

    if (!id.startsWith(CONFIGURATION_ROOT)) {
      CONFIGURATION_ROOT + converted

    } else converted
  }

  val CONFIGURATION_ROOT = "Configuration/"

}
