package com.xebialabs.deployit.task.archive;

import java.util.Map;

import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import org.joda.time.DateTime;

import static com.google.common.collect.Maps.newHashMap;

public class ArchivedStep implements StepState {
    private String description;
    private StepExecutionState state;
    private String log;
    private DateTime startDate;
    private DateTime completionDate;
    private int failureCount;
    private Map<String, String> metadata = newHashMap();

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public StepExecutionState getState() {
        return state;
    }

    @Override
    public String getLog() {
        return log;
    }

    @Override
    public DateTime getStartDate() {
        return startDate;
    }

    @Override
    public DateTime getCompletionDate() {
        return completionDate;
    }

    @Override
    public int getFailureCount() {
        return failureCount;
    }

    @Override
    public Map<String, String> getMetadata() {return metadata;
    }

    @Override
    public boolean getSkippable() {
        return false;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setState(StepExecutionState state) {
        this.state = state;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = startDate;
    }

    public void setCompletionDate(DateTime completionDate) {
        this.completionDate = completionDate;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }
}
