package com.xebialabs.deployit.spring;

import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;

import com.xebialabs.deployit.engine.spi.services.RepositoryFactory;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.plugin.satellite.SatelliteCommunicatorSystem;

import akka.actor.ActorSystem;

@Configuration
@Lazy
public class EngineBeanBuilder {

    @Autowired
    private Archive archive;

    @Autowired
    private RepositoryFactory repositoryAdapter;

    private final ActorSystem system = SatelliteCommunicatorSystem.actorSystem();

    @Bean
    @DependsOn("upgrader")
    public TaskExecutionEngine engine() {
        return new TaskExecutionEngine(archive, repositoryAdapter, system);
    }

    @PreDestroy
    public void destroy(){
        system.shutdown();
        system.awaitTermination();
    }
}
