package com.xebialabs.deployit.service.gc;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.*;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.xlplatform.scheduler.step.DefaultGarbageCollectionStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component("garbageCollectionService")
public class AsyncGarbageCollectionService implements GarbageCollectionService {

    private static final Logger logger = LoggerFactory.getLogger(AsyncGarbageCollectionService.class);

    private final IEngine engine;

    private final GarbageCollectionService garbageCollectionService;

    private final WorkDirFactory workDirFactory;

    @Autowired
    public AsyncGarbageCollectionService(IEngine engine, GarbageCollectionService jackrabbitGarbageCollectionService, WorkDirFactory workDirFactory) {
        this.engine = engine;
        this.garbageCollectionService = jackrabbitGarbageCollectionService;
        this.workDirFactory = workDirFactory;
    }

    @Override
    public void runGarbageCollector() {
        if (!GCSemaphore.claimProcessSlot()) {
            logger.warn("Not starting new garbage collector since garbage collection already in progress");
            return;
        }

        DefaultGarbageCollectionStep garbageCollectionStep = new DefaultGarbageCollectionStep(garbageCollectionService);

        String description = "Garbage collection";
        PhaseContainer stepBlock = BlockBuilders.steps(description, null, Lists.<StepState>newArrayList(new TaskStep(garbageCollectionStep))).build();
        WorkDir workDir = workDirFactory.newWorkDir("gc");
        TaskSpecification spec = new TaskSpecification(description, Permissions.getAuthentication(), workDir, stepBlock, null, false, false, true);
        spec.getListeners().add(new GCSemaphore());
        spec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        String id = engine.register(spec);
        engine.execute(id);
    }
}
