package com.xebialabs.deployit.service.dependency

import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage

object Application {
  def unresolved(id: String): Application = UnresolvedDependency(id)

  def resolved(id: String): Application = ResolvedDependency(id)

  def main(id: String, version: String): Application = MainApplication(id, version)
}

case class Label(udmVersion: Option[DeploymentPackage], range: String) {
  lazy val osgiVersion = udmVersion.map(_.toOsgi)

  override def toString: String = udmVersion.map(_.getVersion).getOrElse("unresolved")

  override def hashCode(): Int = udmVersion.hashCode()

  override def equals(o: Any) = o match {
    case that: Label => that.udmVersion.equals(this.udmVersion)
    case _ => false
  }
}

sealed trait Application {
  val id: String

  override def equals(obj: scala.Any): Boolean = obj match {
    case app: Application => id == app.id
    case _ => false
  }

  override def hashCode(): Int = id.hashCode

  override def toString: String = id
}

case class MainApplication(id: String, version: String) extends Application

case class ResolvedDependency(id: String) extends Application

case class UnresolvedDependency(id: String) extends Application
