package com.xebialabs.deployit.listener.version

object IdExtensions {

  class IdString(id: String) {

    def getName: String = {
      Option(id).getOrElse("").lastIndexOf('/') match {
        case lastSlashPos if lastSlashPos > -1 => id.substring(lastSlashPos + 1)
        case _ => id
      }
    }

    def getParent: String = {
      Option(id).getOrElse("").lastIndexOf('/') match {
        case lastSlashPos if lastSlashPos > 0 => id.substring(0, lastSlashPos)
        case _ => ""
      }
    }
  }

  implicit def idString(id: String): IdString = new IdString(id)
}
