package com.xebialabs.deployit.core.upgrade;

import static com.xebialabs.deployit.jcr.JcrConstants.CONFIGURATION_ITEM_TYPE_PROPERTY_NAME;
import static com.xebialabs.deployit.jcr.JcrConstants.LAST_MODIFIED_AT_PROPERTY_NAME;
import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

import java.util.Calendar;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.jcr.JcrConstants;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;

/**
 * This upgrader adds the new Configuration root node.
 */
public class Deployit38ConfigurationRoot extends Upgrade {
    @Override
    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Running Deployit 3.8 upgrade -- Create new Configuration root node ***");
        try {
            createRoot(((RawRepositoryImpl) repository).getSession(), CONFIGURATION.getRootNodeName());
            logger.info("*** Finished upgrade ***");
            return true;
        } catch (RepositoryException e) {
            throw new UpgradeException("", e);
        }
    }

    private void createRoot(final Session session, final String rootNodeName) throws RepositoryException {
        Node node = session.getRootNode().addNode(rootNodeName);
        node.addMixin(JcrConstants.CONFIGURATION_ITEM_NODETYPE_NAME);
        node.addMixin(NodeType.MIX_VERSIONABLE);
        node.setProperty(CONFIGURATION_ITEM_TYPE_PROPERTY_NAME, "internal." + Root.class.getSimpleName());
        node.setProperty(LAST_MODIFIED_AT_PROPERTY_NAME, Calendar.getInstance());

        session.save();
    }

    @Override
    public Version upgradeVersion() {
        return Version.valueOf("deployit", "3.8.0");
    }

    private static final Logger logger = LoggerFactory.getLogger(Deployit38ConfigurationRoot.class);
}
