package com.xebialabs.deployit.task.archive

import javax.jcr.Node

import com.google.common.base.Preconditions._
import com.google.common.base.Strings
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock
import com.xebialabs.deployit.task.TaskMetadata._
import com.xebialabs.deployit.task.TaskType
import com.xebialabs.deployit.task.TaskType.CONTROL
import NodeNames.TASK_DESCRIPTION

class ControlTaskArchiver(val task: TaskWithBlock) extends TaskArchiver {

  override def save(rootNode: Node) {
    val taskNode = createTaskNode(rootNode)

    fillTaskNode(taskNode)

    val taskName = getMetadata(task, TASK_NAME)
    val targetCI = getMetadata(task, CONTROL_TASK_TARGET_CI)


    taskNode.setProperty(TASK_NAME, taskName)
    taskNode.setProperty(TASK_DESCRIPTION, task.getDescription)
    taskNode.setProperty(CONTROL_TASK_TARGET_CI, targetCI)
  }
}

object ControlTask {

  def unapply(task: TaskWithBlock): Option[TaskArchiver] = {

    if ((CONTROL == TaskType.valueOf(getMetadata(task, TASK_TYPE))) && !metadataContainsKey(task, CLOUD_OPERATION)) {

      checkState(!Strings.isNullOrEmpty(getMetadata(task, TASK_NAME)), "task name must be set for archiving of control tasks", "")
      checkState(!Strings.isNullOrEmpty(getMetadata(task, CONTROL_TASK_TARGET_CI)), "target CI id must be set for archiving of control tasks", "")

      Some(new ControlTaskArchiver(task))

    } else None
  }

}
