package com.xebialabs.deployit.task.archive;

import com.xebialabs.deployit.engine.api.execution.BlockExecutionState;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;

public abstract class ArchivedAbstractBlock implements BlockState, Block {

    private String id;
    private String description;
    private BlockExecutionState state;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public BlockExecutionState getState() {
        return state;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public void setState(final BlockExecutionState state) {
        this.state = state;
    }

    @Override
    public BlockExecutionState state() {
        return getState();
    }

    @Override
    public void state_$eq(BlockExecutionState state) {
        setState(state);
    }

    @Override
    public String description() {
        return getDescription();
    }

    @Override
    public <A extends Block> A newState(BlockExecutionState state) {
        throw new UnsupportedOperationException("Does not work for archived blocks");
    }

    @Override
    public void recovered() {
        throw new UnsupportedOperationException("Does not work for archived blocks");
    }

    @Override
    public BlockPath id() {
        return BlockPath.apply(id);
    }
}
