package com.xebialabs.deployit.core.upgrade;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.security.AccessControlPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;

public class Deployit383AclClear extends Upgrade {

    @Override
    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Running Deployit 3.8.3 Upgrade: Clean policies ***");
        Session session = ((RawRepositoryImpl) repository).getSession();
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(RawRepositoryImpl.QUERY_PREFIX, Query.JCR_SQL2);
            QueryResult execute = query.execute();
            NodeIterator nodes = execute.getNodes();
            while(nodes.hasNext()) {
                Node node = nodes.nextNode();
                String path = node.getPath();
                if (node.hasNode("rep:policy")) {
                    logger.info("Found a rep:policy node under [{}], going to use the AccessControlManager to try to clear it.", path);
                }
                AccessControlPolicy[] policies = session.getAccessControlManager().getPolicies(path);
                for (AccessControlPolicy policy : policies) {
                    logger.info("Found policy [{}] on node [{}]", policy, path);
                    session.getAccessControlManager().removePolicy(path, policy);
                }
            }
        } catch (RepositoryException e) {
            throw new UpgradeException("Failed to run 3.8.3 upgrade", e);
        }
        logger.info("*** Finished upgrade ***");
        return true;
    }

    @Override
    public Version upgradeVersion() {
        return Version.valueOf("deployit", "3.8.3");
    }

    private static final Logger logger = LoggerFactory.getLogger(Deployit383AclClear.class);
}
