/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.source;

import com.google.common.base.Strings;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.importer.source.FileSource;
import com.xebialabs.deployit.util.GuavaFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlSource
implements ImportSource {
    private static final Logger logger = LoggerFactory.getLogger(UrlSource.class);
    private static final String CONTENT_DISPOSITION = "Content-disposition";
    private static final String ATTACHMENT = "attachment";
    private static final String FILENAME = "filename";
    private final URL location;
    private final String user;
    private final String password;
    private FileSource downloaded;
    private File tempDir;

    public UrlSource(URL location, String user, String password) {
        this.location = location;
        this.user = user;
        this.password = password;
    }

    public File getFile() {
        if (this.downloaded == null) {
            this.download();
        }
        return this.downloaded.getFile();
    }

    public void cleanUp() {
        if (this.downloaded != null) {
            this.downloaded.cleanUp();
        }
        if (this.tempDir != null) {
            GuavaFiles.deleteQuietly((File)this.tempDir);
        }
    }

    private void download() {
        try {
            logger.debug("Preparing to download package from {}", (Object)this.location);
            HttpMethod method = this.executeGetRequest();
            this.saveFile(method);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    protected HttpMethod executeGetRequest() throws URISyntaxException, IOException {
        URI uri = this.location.toURI();
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(uri.toString());
        this.configureAuthentication(client);
        int statusCode = client.executeMethod((HttpMethod)method);
        if (statusCode != 200) {
            throw new RuntimeIOException("Failed to download package,status=" + statusCode + ", from url " + this.location);
        }
        return method;
    }

    private void configureAuthentication(HttpClient client) {
        if (this.user != null) {
            client.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.user, this.password);
            client.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        }
    }

    private void saveFile(HttpMethod method) throws IOException {
        try (InputStream in = method.getResponseBodyAsStream();){
            this.tempDir = Files.createTempDir();
            File archive2 = new File(this.tempDir, this.getFileName(method));
            Files.asByteSink((File)archive2, (FileWriteMode[])new FileWriteMode[0]).writeFrom(in);
            this.downloaded = new FileSource(archive2, true);
            logger.debug("Successfully downloaded file {}", (Object)this.downloaded.getFile().getName());
        }
    }

    private String getFileName(HttpMethod method) throws URIException {
        String filename = this.getFilenameFromHeader(method);
        if (filename == null) {
            logger.trace("File name could not be resolved through 'Content-disposition' header");
            filename = this.getFileNameFromPath(method.getURI().getPath());
        }
        logger.debug("File name resolved as {}", (Object)filename);
        return filename;
    }

    private String getFilenameFromHeader(HttpMethod method) {
        Header contentDisposition = method.getResponseHeader(CONTENT_DISPOSITION);
        if (contentDisposition != null) {
            for (HeaderElement element : contentDisposition.getElements()) {
                if (!element.getName().equalsIgnoreCase(ATTACHMENT)) continue;
                NameValuePair filenameParam = element.getParameterByName(FILENAME);
                return filenameParam != null ? Strings.emptyToNull((String)filenameParam.getValue()) : null;
            }
        }
        return null;
    }

    private String getFileNameFromPath(String path) {
        logger.trace("Getting target file name from path {}", (Object)path);
        return new File(path).getName();
    }

    public String toString() {
        return "UrlSource[" + this.location + "]";
    }
}

