package com.xebialabs.deployit.task.archive

import javax.jcr.Node
import com.xebialabs.deployit.jcr.JcrUtils.getProperty
import NodeNames._
import com.xebialabs.deployit.task.archive.BlockType.PHASE_BLOCK_CONTAINER
import scala.collection.convert.wrapAll._
import scala.collection.mutable.ListBuffer

object PhaseContainerReader {
  def unapply(blockNode: Node): Option[BlockReader] = if (blockNode.hasProperty(BLOCK_TYPE) && getProperty(blockNode, BLOCK_TYPE).equals(PHASE_BLOCK_CONTAINER.name()))
    Some(new PhaseContainerReader)
  else None
}

class PhaseContainerReader extends BlockReader {

  override def read(blockNode: Node, loadSteps: Boolean, uptodateModel: Boolean): ArchivedPhaseContainer = {
    val phases = ListBuffer.empty[ArchivedPhase]
    val i = blockNode.getNodes
    while (i.hasNext) {
      val nextNode = i.nextNode()
      phases += new PhaseReader().read(nextNode, loadSteps, uptodateModel)
    }

    val container = new ArchivedPhaseContainer(phases)
    readBasicBlockProperties(blockNode, container, uptodateModel)

    container
  }

  override def readFirstBlock(taskNode: Node, loadSteps: Boolean): ArchivedPhaseContainer =
    read(taskNode, loadSteps, BlockReader.MODEL_UP_TO_DATE)
}