package com.xebialabs.deployit.security.permission;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.APPLICATIONS;
import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.ENVIRONMENTS;
import static com.xebialabs.deployit.security.permission.Permission.definePermission;
import static com.xebialabs.deployit.security.permission.PermissionHandler.Level.BOTH;
import static com.xebialabs.deployit.security.permission.PermissionHandler.Level.CI;
import static com.xebialabs.deployit.security.permission.PermissionHandler.Level.GLOBAL;

public final class DeployitPermissions {

    public static final Permission DISCOVERY = definePermission("discovery", GLOBAL);
    public static final Permission TASK_ASSIGN = definePermission("task#assign", GLOBAL);
    public static final Permission TASK_PREVIEWSTEP = definePermission("task#preview_step", GLOBAL);
    public static final Permission CONTROLTASK_EXECUTE = definePermission("controltask#execute", BOTH);

    public static final Permission IMPORT_INITIAL = definePermission("import#initial", CI, APPLICATIONS, true);
    public static final Permission IMPORT_UPGRADE = definePermission("import#upgrade", CI, APPLICATIONS, true);
    public static final Permission IMPORT_REMOVE = definePermission("import#remove", CI, APPLICATIONS, true);
    public static final Permission DEPLOY_INITIAL = definePermission("deploy#initial", CI, ENVIRONMENTS, true);
    public static final Permission DEPLOY_UPGRADE = definePermission("deploy#upgrade", CI, ENVIRONMENTS, true);
    public static final Permission UNDEPLOY = definePermission("deploy#undeploy", CI, ENVIRONMENTS, true);

    public static final Permission TASK_MOVESTEP = definePermission("task#move_step", BOTH, ENVIRONMENTS);
    public static final Permission TASK_SKIPSTEP = definePermission("task#skip_step", BOTH, ENVIRONMENTS);
    public static final Permission TASK_TAKEOVER = definePermission("task#takeover", BOTH, ENVIRONMENTS);

    public static final Permission REPORT_VIEW = definePermission("report#view", GLOBAL);

}
