/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployable;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.plugin.api.xld.AppliedDistribution;
import com.xebialabs.deployit.plugin.api.xld.DistributionVersion;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.DeployedApplicationFactory;
import com.xebialabs.deployit.service.deployment.TypeCalculator;
import com.xebialabs.deployit.service.deployment.setter.AbstractPropertySetter;
import com.xebialabs.deployit.service.deployment.setter.DefaultPropertySetter;
import com.xebialabs.deployit.service.deployment.setter.FallbackPropertySetter;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedPropertySetter {
    private final TypeCalculator calculator;
    private final ServerConfiguration serverConfiguration;
    private final DefaultPropertySetter defaultPropertySetter;
    private final FallbackPropertySetter fallbackPropertySetter;
    private static final Logger logger = LoggerFactory.getLogger(DeployedPropertySetter.class);

    @Autowired
    public DeployedPropertySetter(TypeCalculator typeCalculator, ServerConfiguration serverConfiguration, DefaultPropertySetter defaultPropertySetter, FallbackPropertySetter fallbackPropertySetter) {
        this.calculator = typeCalculator;
        this.serverConfiguration = serverConfiguration;
        this.defaultPropertySetter = defaultPropertySetter;
        this.fallbackPropertySetter = fallbackPropertySetter;
    }

    public void setProperties(EmbeddedDeployedContainer<?, ?> deployed, EmbeddedDeployedContainer<?, ?> previousDeployed, ConsolidatedDictionary dictionary, Set<String> missingPlaceholdersAggregator) {
        Checks.checkArgument((previousDeployed == null || deployed.getType().equals((Object)previousDeployed.getType()) ? 1 : 0) != 0, (String)"New and existing target types should be equal when upgrading (%s)", (Object[])new Object[]{deployed.getType()});
        for (PropertyDescriptor deployedPropDesc : deployed.getType().getDescriptor().getPropertyDescriptors()) {
            if (deployedPropDesc.isDeployedSpecific()) continue;
            if (this.isEmbeddedProperty(deployedPropDesc)) {
                this.generateEmbeddeds(deployed, deployedPropDesc, dictionary, missingPlaceholdersAggregator);
                continue;
            }
            ConfigurationItem currentDeployable = deployed.getDeployable();
            ConfigurationItem previousDeployable = previousDeployed == null ? null : previousDeployed.getDeployable();
            this.setProperty((ConfigurationItem)deployed, (ConfigurationItem)previousDeployed, currentDeployable, previousDeployable, dictionary, deployedPropDesc, missingPlaceholdersAggregator);
        }
    }

    public void setProperties(AppliedDistribution currentDeployedApp, AppliedDistribution existingDeployedApp, ConsolidatedDictionary dictionary, Set<String> missingPlaceholdersAggregator) {
        DistributionVersion previousDeployable = existingDeployedApp == null ? null : existingDeployedApp.getVersion();
        DistributionVersion currentDeployable = currentDeployedApp.getVersion();
        for (PropertyDescriptor deployedPropDesc : currentDeployedApp.getType().getDescriptor().getPropertyDescriptors()) {
            if (deployedPropDesc.isDeployedSpecific()) continue;
            this.setProperty((ConfigurationItem)currentDeployedApp, (ConfigurationItem)existingDeployedApp, (ConfigurationItem)currentDeployable, (ConfigurationItem)previousDeployable, dictionary, deployedPropDesc, missingPlaceholdersAggregator);
        }
        for (PropertyDescriptor pd : currentDeployable.getType().getDescriptor().getPropertyDescriptors()) {
            if (!currentDeployedApp.hasProperty(pd.getName())) continue;
            PropertyDescriptor deployedAppPropertyDescriptor = currentDeployedApp.getType().getDescriptor().getPropertyDescriptor(pd.getName());
            this.setProperty((ConfigurationItem)currentDeployedApp, (ConfigurationItem)existingDeployedApp, (ConfigurationItem)currentDeployable, (ConfigurationItem)previousDeployable, dictionary, deployedAppPropertyDescriptor, missingPlaceholdersAggregator);
        }
    }

    private void setProperty(ConfigurationItem currentTarget, ConfigurationItem previousTarget, ConfigurationItem currentSource, ConfigurationItem previousSource, ConsolidatedDictionary dictionary, PropertyDescriptor targetPropertyDescriptor, Set<String> missingPlaceholdersAggregator) {
        logger.debug("Going to set property {} of currentTarget {}", (Object)targetPropertyDescriptor.getFqn(), (Object)currentTarget);
        AbstractPropertySetter propertySetter = this.serverConfiguration.isServerMappingOverrideDeployedFieldsOnUpdate() ? this.defaultPropertySetter : this.fallbackPropertySetter;
        propertySetter.setProperty(currentTarget, previousTarget, currentSource, previousSource, dictionary, targetPropertyDescriptor, missingPlaceholdersAggregator);
    }

    private void generateEmbeddeds(EmbeddedDeployedContainer<?, ?> deployed, PropertyDescriptor deployedPropDesc, ConsolidatedDictionary dictionary, Set<String> missingPlaceholdersAggregator) {
        ConfigurationItem deployable = deployed.getDeployable();
        String name = deployedPropDesc.getName();
        AbstractCollection embeddedDeployeds = deployedPropDesc.getKind() == PropertyKind.LIST_OF_CI ? Lists.newArrayList() : Sets.newHashSet();
        PropertyDescriptor deployableProperty = deployable.getType().getDescriptor().getPropertyDescriptor(name);
        if (deployableProperty == null) {
            logger.info("Deployed [{}] has embedded deployeds in property [{}] but source [{}] has no such property.", new Object[]{deployed.getId(), deployedPropDesc.getFqn(), deployable.getId()});
            return;
        }
        Collection embeddedDeployables = (Collection)deployableProperty.get(deployable);
        for (EmbeddedDeployable embeddedDeployable : embeddedDeployables) {
            List<Type> embeddedDeployedTypes = this.calculator.findAllMostSpecificDeployedTypesForDeployableAndContainerTypes(embeddedDeployable.getType(), deployed.getType());
            Collection filtered = Collections2.filter(embeddedDeployedTypes, input -> input.instanceOf(deployedPropDesc.getReferencedType()));
            if (filtered.isEmpty()) {
                logger.info("Not found a matching EmbeddedDeployed type for [{}] and [{}]", (Object)embeddedDeployable.getType(), (Object)deployed.getType());
                continue;
            }
            if (filtered.size() > 1) {
                logger.error("Found more than 1 ({}) compatible EmbeddedDeployed type for [{}] and [{}]", new Object[]{filtered, embeddedDeployable.getType(), deployed.getType()});
                throw new Checks.IncorrectArgumentException("Found more than 1 (%s) compatible EmbeddedDeployed type for [%s] and [%s]", new Object[]{filtered, embeddedDeployable.getType(), deployed.getType()});
            }
            Type embeddedDeployedType = (Type)filtered.iterator().next();
            EmbeddedDeployed embeddedDeployed = (EmbeddedDeployed)embeddedDeployedType.getDescriptor().newInstance(IdGenerator.generateId(deployed, (String)embeddedDeployable.getId()));
            embeddedDeployed.setDeployable((ConfigurationItem)embeddedDeployable);
            embeddedDeployed.setContainer(deployed);
            if (MustachePlaceholderScanner.hasPlaceholders((String)embeddedDeployed.getName())) {
                try {
                    dictionary.resolveDeployedName((EmbeddedDeployedContainer)embeddedDeployed);
                }
                catch (DictionaryValueException e) {
                    throw new DeployedApplicationFactory.IncorrectDeployedException(e, "Couldn't generate name for target from [%s]", embeddedDeployable.getId());
                }
            }
            embeddedDeployeds.add(embeddedDeployed);
            this.setProperties((EmbeddedDeployedContainer<?, ?>)embeddedDeployed, null, dictionary, missingPlaceholdersAggregator);
        }
        deployedPropDesc.set(deployed, (Object)embeddedDeployeds);
    }

    private boolean isEmbeddedProperty(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.isAsContainment() && (propertyDescriptor.getKind() == PropertyKind.SET_OF_CI || propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI) && propertyDescriptor.getReferencedType().isSubTypeOf(Type.valueOf(EmbeddedDeployed.class));
    }
}

