package com.xebialabs.deployit.task.archive

import javax.jcr.Node

import com.xebialabs.deployit.engine.api.execution.BlockExecutionState._
import com.xebialabs.deployit.engine.api.execution.{StepState, BlockExecutionState, StepExecutionState}
import com.xebialabs.deployit.jcr.JcrUtils._
import com.xebialabs.deployit.task.archive.NodeNames._

import scala.collection.mutable.ListBuffer
import scala.collection.convert.wrapAll._

class StepReader {

  def read(stepNode: Node, loadSteps: Boolean, uptodateModel: Boolean): ArchivedStep = {
    val step = new ArchivedStep()
    step.setDescription(getProperty(stepNode, DESCRIPTION))
    step.setState(StepExecutionState.valueOf(getProperty(stepNode, STATE)))
    step.setStartDate(getDate(stepNode, START_DATE))
    step.setCompletionDate(getDate(stepNode, COMPLETION_DATE))
    step.setLog(getProperty(stepNode, LOG))
    step.setFailureCount(getIntegerProperty(stepNode, FAILURE_COUNT))

    step
  }

  def readFirstBlock(firstStepNode: Node, loadSteps: Boolean): ArchivedPhaseContainer = {
    val stepBlock = new ArchivedStepBlock()
    stepBlock.setState(BlockExecutionState.STOPPED)
    stepBlock.setDescription("Plan")



    if (loadSteps) {
      val steps = ListBuffer.empty[StepState]
      val nodes = firstStepNode.getParent.getNodes
      while (nodes.hasNext) {
        steps += new StepReader().read(nodes.nextNode(), loadSteps, BlockReader.DEPRECATED_MODEL)
      }
      stepBlock.setSteps(steps)
    }
    wrapInPhaseContainer(stepBlock)
  }

  protected def wrapInPhaseContainer(firstBlock: ArchivedAbstractBlock): ArchivedPhaseContainer = {
    val phase = new ArchivedPhase(firstBlock)

    phase.setState(STOPPED)
    phase.setDescription("phase1")
    val container = new ArchivedPhaseContainer(java.util.Arrays.asList(phase))
    container.setState(STOPPED)
    container.setDescription("")

    container
  }

}
