package com.xebialabs.deployit.core.upgrade;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import java.util.Collection;
import java.util.List;

public class Deployit371PolicyClear extends Upgrade {
    @Override
    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Running Deployit 3.7.1 upgrade -- Remove policies blocking deletion ***");
        try {
            AccessControlManager manager = getAccessControlManager(repository);
            Collection<Type> subtypes = DescriptorRegistry.getSubtypes(Type.valueOf(ConfigurationItem.class));
            for (Type subtype : subtypes) {
                List<Node> nodesByType = repository.findNodesByType(subtype);
                for (Node node : nodesByType) {
                    AccessControlPolicy[] policies = manager.getPolicies(node.getPath());
                    if (policies.length > 0) {
                        logger.info("Node [{}] has unwanted policies, cleaning them", node.getPath());
                        clearPolicies(node, manager);
                    }
                }
            }
            logger.info("*** Finished Deployit 3.7.1 upgrade ***");
            return true;
        } catch (RepositoryException e) {
            throw new UpgradeException("", e);
        }
    }

    private void clearPolicies(Node node, AccessControlManager manager) throws RepositoryException {
        AccessControlPolicy[] policies = manager.getPolicies(node.getPath());
        for (AccessControlPolicy policy : policies) {
            manager.removePolicy(node.getPath(), policy);
        }
    }

    @Override
    public Version upgradeVersion() {
        return Version.valueOf("deployit", "3.7.1");
    }

    private static AccessControlManager getAccessControlManager(RawRepository repository) throws RepositoryException {
        Session session = ((RawRepositoryImpl) repository).getSession();
        return session.getAccessControlManager();
    }

    private static final Logger logger = LoggerFactory.getLogger(Deployit371PolicyClear.class);
}
