package com.xebialabs.deployit.jcr.grouping;

import com.xebialabs.deployit.task.archive.ArchivedTask;

import java.lang.reflect.Field;


public class Sum implements Function<Long> {
    private final String property;
    private final String name;
    private final Field field;

    public Sum(String name, String property) {
        this.name = name;
        this.property = property;
        this.field = getField(property);
    }

    private Field getField(String property) {
        Field field = null;
        try {
            field = ArchivedTask.class.getDeclaredField(property);
            field.setAccessible(true);
        } catch (NoSuchFieldException e) {
            new IllegalArgumentException(String.format("Property is %s not defined in %s.", property, ArchivedTask.class.getName()), e);
        }
        return field;
    }

    @Override
    public Long invoke(Object previousValue, ArchivedTask task) {
        try {
            if (previousValue != null)
                return (Long) previousValue + field.getLong(task);
            else
                return field.getLong(task);
        } catch (Exception e) {
            throw new IllegalArgumentException("Property " + property + " is not numeric.", e);
        }
    }

    @Override
    public String getName() {
        return name;
    }
}
