package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecification;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.NonRemotableExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static com.xebialabs.deployit.deployment.ChangeSetBuilder.determineChanges;
import static com.xebialabs.deployit.engine.spi.execution.Transitions.checkTransition;

@SuppressWarnings("serial")
public class ReferentialIntegrityTrigger implements NonRemotableExecutionStateListener {
    private MultiDeltaSpecification fullSpec;

    public ReferentialIntegrityTrigger(MultiDeltaSpecification fullSpec) {
        this.fullSpec = fullSpec;
    }

    @Override
    public void stepStateChanged(StepExecutionStateEvent event) {
    }

    @Override
    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (checkTransition(event, TaskExecutionState.PENDING, TaskExecutionState.EXECUTING)) {
            checkReferentialIntegrity(determineChanges(fullSpec));
        }
    }

    private void checkReferentialIntegrity(ChangeSet changeSet) {
        RepositoryServiceHolder.getRepositoryService().checkReferentialIntegrity(changeSet);
    }

    private static final Logger logger = LoggerFactory.getLogger(ReferentialIntegrityTrigger.class);
}
