package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashSet;
import java.util.Set;

public class PlaceholderPropertyDeployedGenerator extends AbstractChainGenerator {

    private final Logger logger = LoggerFactory.getLogger(PlaceholderPropertyDeployedGenerator.class);

    public PlaceholderPropertyDeployedGenerator(DeployedGenerator processor) {
        super(processor);
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        DeployedArtifactPlaceholdersResolver placeholdersResolver = deploymentContext.getBeanSupplier().getBean(DeployedArtifactPlaceholdersResolver.class);
        Set<String> unresolvedPlaceholders = new HashSet<>();
        GeneratedDeployeds generatedDeployeds = nextGenerator.generateDeployed(deploymentContext, deployable, container);
        generatedDeployeds.getDeployeds().forEach(d ->
                placeholdersResolver.resolvePlaceholders(d,
                        deploymentContext.dictionaryFilteredByContainer(container),
                        unresolvedPlaceholders));
        generatedDeployeds.addUnresolvedPlaceholder(unresolvedPlaceholders);
        logger.debug("'{}' generated following deployeds [{}]", nextGenerator.getClass().getName(), generatedDeployeds);
        return generatedDeployeds;
    }
}
