/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecification;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.service.deployment.ImprovedPartialCommitTrigger;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.overthere.local.LocalFile;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u00015\u0011qBU8mY\n\f7m[*feZL7-\u001a\u0006\u0003\u0007\u0011\t!\u0002Z3qY>LX.\u001a8u\u0015\t)a!A\u0004tKJ4\u0018nY3\u000b\u0005\u001dA\u0011\u0001\u00033fa2|\u00170\u001b;\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\u000e\u000e\u0003YQ!a\u0006\r\u0002\u000bMdg\r\u000e6\u000b\u0003e\t\u0001b\u001a:jujdW\rZ\u0005\u00037Y\u0011q\u0001T8hO&tw\r\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u0019)gnZ5oKB\u0011qdI\u0007\u0002A)\u0011\u0011EI\u0001\u0007i\u0006\u001c8.\u001a:\u000b\u0005u1\u0011B\u0001\u0013!\u0005\u001dIUI\\4j]\u0016D\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0012I\u0016\u0004Hn\\=nK:$8+\u001a:wS\u000e,\u0007C\u0001\u0015*\u001b\u0005\u0011\u0011B\u0001\u0016\u0003\u0005E!U\r\u001d7ps6,g\u000e^*feZL7-\u001a\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00079z\u0003\u0007\u0005\u0002)\u0001!)Qd\u000ba\u0001=!)ae\u000ba\u0001O!\u00121F\r\t\u0003gyj\u0011\u0001\u000e\u0006\u0003kY\n!\"\u00198o_R\fG/[8o\u0015\t9\u0004(A\u0004gC\u000e$xN]=\u000b\u0005eR\u0014!\u00022fC:\u001c(BA\u001e=\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A\u001f\u0002\u0007=\u0014x-\u0003\u0002@i\tI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006\u0003\u0002!\tAQ\u0001\te>dGNY1dWR\u00111I\u0012\t\u0003?\u0011K!!\u0012\u0011\u0003#Q\u000b7o[*qK\u000eLg-[2bi&|g\u000eC\u0003H\u0001\u0002\u0007\u0001*\u0001\u0003uCN\\\u0007CA\u0010J\u0013\tQ\u0005E\u0001\u0003UCN\\\u0007\"\u0002'\u0001\t\u0013i\u0015aG2sK\u0006$XMU8mY\n\f7m[*qK\u000eLg-[2bi&|g\u000e\u0006\u0003D\u001d>#\u0006\"B$L\u0001\u0004A\u0005\"\u0002)L\u0001\u0004\t\u0016\u0001\u00069beRL\u0017\r\\\"p[6LG\u000f\u0016:jO\u001e,'\u000f\u0005\u0002)%&\u00111K\u0001\u0002\u001d\u00136\u0004(o\u001c<fIB\u000b'\u000f^5bY\u000e{W.\\5u)JLwmZ3s\u0011\u0015)6\n1\u0001W\u0003!9xN]6ESJ\u001c\bcA,`E:\u0011\u0001,\u0018\b\u00033rk\u0011A\u0017\u0006\u000372\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005y\u0003\u0012a\u00029bG.\fw-Z\u0005\u0003A\u0006\u0014A\u0001T5ti*\u0011a\f\u0005\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K\u001a\t!B]3q_NLGo\u001c:z\u0013\t9GMA\u0004X_J\\G)\u001b:\t\u000b%\u0004A\u0011\u00026\u0002=\u001d,G/\u00118e+:\u0014XmZ5ti\u0016\u0014xk\u001c:lI&\u00148\t\\3b]\u0016\u0014HCA6q!\tag.D\u0001n\u0015\t9e!\u0003\u0002p[\n)rk\u001c:lI&\u00148\t\\3b]\u0016\u0014HK]5hO\u0016\u0014\b\"B9i\u0001\u0004\u0011\u0018aB2p]R,\u0007\u0010\u001e\t\u0003?ML!\u0001\u001e\u0011\u0003)Q\u000b7o[#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u00151\b\u0001\"\u0003x\u0003]9W\r\u001e)beRL\u0017\r\\\"p[6LG\u000f\u0016:jO\u001e,'\u000f\u0006\u0002Rq\")\u0011/\u001ea\u0001e\")!\u0010\u0001C\u0005w\u00069\u0011M]2iSZ,GC\u0001?\u0000!\tyQ0\u0003\u0002\u007f!\t!QK\\5u\u0011\u00159\u0015\u00101\u0001IQ\r\u0001\u00111\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\u001e\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002\u000e\u0005\u001d!!C\"p[B|g.\u001a8u\u0001")
public class RollbackService
implements Logging {
    private final IEngine engine;
    private final DeploymentService deploymentService;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RollbackService rollbackService = this;
        synchronized (rollbackService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public TaskSpecification rollback(Task task) {
        this.logger().debug((Function0)new Serializable(this, task){
            public static final long serialVersionUID = 0L;
            private final Task task$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Going to rollback task ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.task$1.getId()}));
            }
            {
                this.task$1 = task$1;
            }
        });
        TaskExecutionContext context = task.getContext();
        WorkdirCleanerTrigger workdirCleanerTrigger = this.getAndUnregisterWorkdirCleaner(context);
        ImprovedPartialCommitTrigger partialCommitTrigger = this.getPartialCommitTrigger(context);
        TaskSpecification rollbackSpecification = this.createRollbackSpecification(task, partialCommitTrigger, (List<WorkDir>)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(workdirCleanerTrigger.getWorkDirs()).toList());
        this.archive(task);
        TaskMetadata.putMetadata(rollbackSpecification, TaskMetadata.TASK_TYPE, TaskType.ROLLBACK.name());
        TaskMetadata.putMetadata(rollbackSpecification, TaskMetadata.ROLLBACK_TASK, task.getId());
        return rollbackSpecification;
    }

    private TaskSpecification createRollbackSpecification(Task task, ImprovedPartialCommitTrigger partialCommitTrigger, List<WorkDir> workDirs) {
        workDirs.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RollbackService $outer;

            public final void apply(WorkDir wd) {
                LocalFile from = LocalFile.from((File)new File(wd.getPath()));
                if (!from.exists()) {
                    this.$outer.debug((Function0<Object>)new Serializable(this, from){
                        public static final long serialVersionUID = 0L;
                        private final LocalFile from$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Re-creating workdir ", " because it was deleted by the original deployment."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.from$1.getPath()}));
                        }
                        {
                            this.from$1 = from$1;
                        }
                    });
                    from.mkdir();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        MultiDeltaSpecification rollbackSpec = partialCommitTrigger.checkpointManager().prepareRollback();
        return this.deploymentService.getTaskFullSpecification(rollbackSpec, task.getWorkDir(), (WorkDir[])workDirs.toArray(ClassTag$.MODULE$.apply(WorkDir.class)));
    }

    private WorkdirCleanerTrigger getAndUnregisterWorkdirCleaner(TaskExecutionContext context) {
        String name = WorkdirCleanerTrigger.class.getName();
        return (WorkdirCleanerTrigger)context.unsetAttribute(name).get();
    }

    private ImprovedPartialCommitTrigger getPartialCommitTrigger(TaskExecutionContext context) {
        String name = ImprovedPartialCommitTrigger.class.getName();
        return (ImprovedPartialCommitTrigger)context.getAttribute(name);
    }

    private void archive(Task task) {
        block4: {
            block3: {
                block2: {
                    TaskExecutionState taskExecutionState = task.getState();
                    TaskExecutionState taskExecutionState2 = TaskExecutionState.EXECUTED;
                    if (taskExecutionState != null ? !taskExecutionState.equals(taskExecutionState2) : taskExecutionState2 != null) break block2;
                    this.engine.archive(task.getId());
                    break block3;
                }
                if (!((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TaskExecutionState[]{TaskExecutionState.STOPPED, TaskExecutionState.ABORTED, TaskExecutionState.FAILED}))).contains((Object)task.getState())) break block4;
                this.engine.cancel(task.getId());
            }
            return;
        }
        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can only rollback a STOPPED, FAILED, ABORTED or EXECUTED task [", " (", ")]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task.getId(), task.getState()})));
    }

    @Autowired
    public RollbackService(IEngine engine, DeploymentService deploymentService) {
        this.engine = engine;
        this.deploymentService = deploymentService;
        Logging.class.$init$((Logging)this);
    }
}

